# 機能設計書 61-ツール自動ダウンロード

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「ツール自動ダウンロード」機能の設計仕様を定義する。この機能は、エンコードに必要な外部ツール（ffmpeg、x265、mkvmerge等）を自動的にダウンロードし、インストールする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：StaxRipは多数の外部ツール（エンコーダー、Demuxer、Muxer等）に依存して動作するが、これらのツールを個別に手動でダウンロード・設定することはエンドユーザーにとって煩雑である。本機能により、必要なツールを自動的に取得・更新できるようにすることで、ユーザーのセットアップ負担を軽減し、常に最新のツールを利用できる環境を提供する。

**機能の利用シーン**：
- 初回起動時に必要なツールが見つからない場合
- AppsForm（ツール管理画面）からユーザーが手動で更新を要求した場合
- ツールのバージョンが古い場合の更新時

**主要な処理内容**：
1. パッケージ情報の取得（Package.vb定義に基づく）
2. ダウンロードURLからリリースページをスクレイピング
3. 適切なダウンロードファイル（7z/zip/exe）の特定
4. ダウンロードフォームでのファイル取得
5. 7-Zipによるアーカイブの解凍
6. 旧ファイルの削除と新ファイルの配置
7. バージョン情報の更新

**関連システム・外部連携**：GitHub、各ツールの公式リリースページ、7-Zipアーカイバー

**権限による制御**：特になし（デスクトップアプリケーションとして動作）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | AppsForm | 主画面 | ツール一覧の表示、ダウンロード実行 |
| - | DownloadForm | 参照画面 | ダウンロード進捗の表示 |
| - | TaskDialog | 結果表示画面 | 確認ダイアログ、サブフォルダ選択 |

## 機能種別

ファイル操作 / 外部連携 / データ同期

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Package | Package | Yes | ダウンロード対象のパッケージ情報 | DownloadURLが設定されていること |
| updateUI | IUpdateUI | Yes | UI更新用インターフェース | Null不可 |

### 入力データソース

- Package.vbで定義されたパッケージ情報（ダウンロードURL、ファイル名、除外パターン等）
- HTTPリクエストによるリリースページの取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ダウンロードファイル | File | ダウンロードされた圧縮ファイル |
| 解凍フォルダ | Directory | 解凍された一時フォルダ |
| ターゲットディレクトリ | Directory | ツールの配置先ディレクトリ |

### 出力先

- ツールディレクトリ（Package.Directoryで指定）
- バージョン情報（Package.SetVersionで保存）

## 処理フロー

### 処理シーケンス

```
1. Update()呼び出し
   └─ HttpClientでダウンロードURLからHTMLを取得
2. 正規表現でダウンロードリンクを抽出
   └─ パターン: href=(""|')[^ ]+\.(7z|zip|exe)(""|')
3. Ignoreフィルタでx86版等を除外
   └─ Package.Excludeとx86パターンでフィルタリング
4. Download()でファイルダウンロード
   └─ DownloadFormで進捗表示
5. Extract()で7-Zipによる解凍
   └─ サブフォルダがある場合は適切なフォルダを選択
6. DeleteOldFiles()で旧ファイル削除
   └─ Package.Keepで指定されたファイルは保持
7. CopyFiles()で新ファイル配置
   └─ 解凍フォルダからターゲットディレクトリへコピー
8. EditVersion()でバージョン更新
   └─ ユーザー入力でバージョン名を設定
```

### フローチャート

```mermaid
flowchart TD
    A[Update開始] --> B[ダウンロードURLからHTML取得]
    B --> C[正規表現でリンク抽出]
    C --> D{適切なファイル発見?}
    D -->|Yes| E[ダウンロード確認ダイアログ]
    D -->|No| Z[終了]
    E -->|OK| F[DownloadFormでダウンロード]
    E -->|Cancel| Z
    F --> G{ダウンロード成功?}
    G -->|Yes| H[7-Zipで解凍]
    G -->|No| I[エラー表示]
    H --> J{サブフォルダ複数?}
    J -->|Yes| K[TaskDialogで選択]
    J -->|No| L[旧ファイル削除確認]
    K --> L
    L -->|OK| M[旧ファイル削除]
    L -->|Cancel| Z
    M --> N[新ファイルコピー確認]
    N -->|OK| O[新ファイルコピー]
    N -->|Cancel| Z
    O --> P[バージョン入力ダイアログ]
    P --> Q[バージョン情報更新]
    Q --> R[UI更新]
    I --> Z
    R --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-61-01 | x86除外 | 64ビット環境ではx86版ファイルをダウンロード対象から除外 | Environment.Is64BitProcess = True |
| BR-61-02 | 除外パターン | Package.Excludeで指定されたパターンを含むファイルを除外 | ダウンロードリンク検索時 |
| BR-61-03 | 保持ファイル | Package.Keepで指定されたファイルは旧ファイル削除時に保持 | 旧ファイル削除処理時 |
| BR-61-04 | Include優先 | Package.Includeが設定されている場合、そのパターンを含むファイルのみ対象 | ダウンロードリンク検索時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。設定情報はApplicationSettingsを通じてファイルに保存される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | HTTP Error | ダウンロードURL取得失敗 | エラーメッセージ表示 |
| - | Extract Error | 7-Zip解凍失敗 | 終了コードを含むエラーメッセージ表示 |
| - | File Missing | 解凍後にパッケージファイルが見つからない | エラーメッセージ表示 |
| - | Download Canceled | ユーザーがダウンロードをキャンセル | 情報メッセージ表示、一時ファイル削除 |

### リトライ仕様

自動リトライは行わない。ユーザーが手動で再実行する必要がある。

## トランザクション仕様

ファイル操作のため、トランザクション管理は行わない。処理が中断した場合、一時フォルダにファイルが残る可能性がある。

## パフォーマンス要件

- ダウンロード速度はネットワーク環境に依存
- 解凍速度は7-Zipの性能に依存
- ファイルコピーは対象ファイルサイズに依存

## セキュリティ考慮事項

- HTTPSによる通信暗号化
- ダウンロードファイルのソースは信頼できる公式サイトまたはGitHubリリース
- ユーザー確認ダイアログによる操作の明示的な同意取得

## 備考

- 7-Zipが必要なため、Package.SevenZipが利用可能であることが前提
- ダウンロードファイルはデスクトップに一時保存される
- 解凍後の一時フォルダはごみ箱に送られる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージの定義と構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | Packageクラスの定義、各プロパティの役割（DownloadURL、Filename、Keep、Exclude等） |

**読解のコツ**: Packageクラスの各Shared Property定義（例：ffmpeg, x265）を見ることで、どのツールがどのような設定でダウンロードされるかを理解できる。

#### Step 2: エントリーポイントを理解する

ツール更新処理の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | ツール管理画面でのダウンロードボタン処理 |

**主要処理フロー**:
1. **AppsForm**: ツール選択後、更新ボタンクリックでToolUpdate.Update()を呼び出し

#### Step 3: 更新処理の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | 更新処理のメインロジック |

**主要処理フロー**:
- **24-45行目**: Update() - HTTPでリリースページ取得、正規表現でリンク抽出
- **47-66行目**: Download() - ダウンロード確認、DownloadForm呼び出し
- **68-126行目**: Extract() - 7-Zip解凍、サブフォルダ選択
- **128-159行目**: DeleteOldFiles() - 旧ファイル削除
- **161-186行目**: CopyFiles() - 新ファイルコピー
- **188-199行目**: EditVersion() - バージョン情報入力・保存
- **201-211行目**: Ignore() - 除外パターンマッチング

#### Step 4: ダウンロードフォームを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ダウンロード進捗表示と実際のダウンロード処理 |

### プログラム呼び出し階層図

```
AppsForm (ツール管理画面)
    │
    └─ ToolUpdate.Update()
           │
           ├─ HttpClient.GetStringAsync() [リリースページ取得]
           │
           ├─ Download()
           │      └─ DownloadForm [ダウンロード実行]
           │
           ├─ Extract()
           │      ├─ Package.SevenZip.Path [7-Zip呼び出し]
           │      └─ TaskDialog [サブフォルダ選択]
           │
           ├─ DeleteOldFiles()
           │      └─ FileHelp.Delete() / FolderHelp.Delete()
           │
           ├─ CopyFiles()
           │      └─ FileHelp.Copy() / FolderHelp.Copy()
           │
           └─ EditVersion()
                  └─ Package.SetVersion()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Package.DownloadURL ───▶ HttpClient取得 ───▶ HTML
                                │
                                ▼
正規表現パターン ───────▶ リンク抽出 ───▶ ダウンロードURL
                                │
                                ▼
ダウンロードURL ────────▶ DownloadForm ───▶ 圧縮ファイル
                                │
                                ▼
圧縮ファイル ──────────▶ 7-Zip解凍 ───▶ 解凍フォルダ
                                │
                                ▼
解凍フォルダ ──────────▶ ファイルコピー ───▶ ターゲットディレクトリ
                                │
                                ▼
バージョン名 ──────────▶ SetVersion() ───▶ 設定ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | ツール更新処理のメインロジック |
| Package.vb | `Source/General/Package.vb` | ソース | パッケージ定義と管理 |
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | ツール管理画面 |
| DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ソース | ダウンロード進捗画面 |
| FileHelp.vb | `Source/General/FileHelp.vb` | ソース | ファイル操作ヘルパー |
| FolderHelp.vb | `Source/General/FolderHelp.vb` | ソース | フォルダ操作ヘルパー |
