# 機能設計書 62-MediaInfo表示

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「MediaInfo表示」機能の設計仕様を定義する。この機能は、メディアファイル（ビデオ、オーディオ）の詳細な技術情報を表示するための機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：エンコード作業において、ソースファイルの技術情報（コーデック、解像度、ビットレート、音声トラック情報等）を正確に把握することは品質管理の観点から非常に重要である。本機能により、MediaInfoライブラリを活用して詳細なメディア情報を取得・表示し、エンコード設定の最適化や問題診断を支援する。

**機能の利用シーン**：
- ソースファイル読み込み時の情報確認
- エンコード前の技術仕様確認
- 出力ファイルの品質検証
- トラブルシューティング時の情報収集

**主要な処理内容**：
1. MediaInfo.dll（ネイティブライブラリ）の読み込み
2. メディアファイルのオープンと解析
3. 各種メディア情報（General、Video、Audio、Text等）の取得
4. MediaInfo.NET GUIアプリケーションによる情報表示
5. 取得情報のコピー・エクスポート機能

**関連システム・外部連携**：MediaInfo.dll（MediaAreaライブラリ）、MediaInfo.NET（GUI表示アプリケーション）

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | MainForm | 主画面 | メニューからMediaInfo表示を呼び出し |
| - | MediaInfo.NET | 外部アプリ | メディア情報の詳細表示 |

## 機能種別

情報表示 / 外部連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FilePath | String | Yes | 解析対象のメディアファイルパス | ファイルが存在すること |

### 入力データソース

- ソースファイルパス（p.SourceFile）
- ターゲットファイルパス（p.TargetFile）
- ユーザーがファイルダイアログで選択したファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| General情報 | String | コンテナ形式、ファイルサイズ、ビットレート等 |
| Video情報 | String | コーデック、解像度、フレームレート、HDR情報等 |
| Audio情報 | String | コーデック、チャンネル数、サンプルレート等 |
| Text情報 | String | 字幕形式、言語等 |

### 出力先

- MediaInfo.NET GUIウィンドウ
- クリップボード（コピー機能使用時）

## 処理フロー

### 処理シーケンス

```
1. メニューまたはショートカットからMediaInfo表示を呼び出し
   └─ Tools > MediaInfo... メニュー選択
2. 対象ファイルパスの決定
   └─ ソースファイル/ターゲットファイル/ダイアログ選択
3. MediaInfo.NETの起動
   └─ Package.MediaInfoNET.Pathを使用
4. ファイルパスを引数として渡す
   └─ コマンドライン引数でファイル指定
5. MediaInfo.NETがMediaInfo.dllを使用して解析
   └─ ネイティブライブラリによる解析
6. 結果をGUIで表示
```

### フローチャート

```mermaid
flowchart TD
    A[MediaInfo表示呼び出し] --> B{ファイル指定あり?}
    B -->|Yes| C[指定ファイル使用]
    B -->|No| D[ファイル選択ダイアログ]
    D --> E{ファイル選択?}
    E -->|Yes| C
    E -->|No| Z[終了]
    C --> F[MediaInfo.NET起動]
    F --> G[MediaInfo.dllでファイル解析]
    G --> H[情報表示]
    H --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-62-01 | ファイル存在チェック | 指定ファイルが存在しない場合はエラー表示 | ファイルパス指定時 |
| BR-62-02 | サポート形式 | 一般的なメディア形式（MKV、MP4、AVI等）を解析可能 | 常時 |

### 計算ロジック

特になし（情報取得・表示機能）

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | File Not Found | 指定ファイルが存在しない | エラーメッセージ表示 |
| - | MediaInfo.NET Not Found | MediaInfo.NETが見つからない | ツールダウンロードを促す |
| - | DLL Load Error | MediaInfo.dllの読み込み失敗 | ライブラリ再インストール |

### リトライ仕様

自動リトライは行わない。

## トランザクション仕様

該当なし（読み取り専用機能）

## パフォーマンス要件

- 小規模ファイル：1秒以内に解析完了
- 大規模ファイル（数GB）：数秒程度
- 解析はファイルヘッダーおよびメタデータのみ（フルスキャン不要）

## セキュリティ考慮事項

- ローカルファイルのみ対象
- 外部への情報送信なし
- 一時ファイル作成なし

## 備考

- MediaInfo.dllはMediaAreaプロジェクトが提供
- MediaInfo.NETはStaxRip用にカスタマイズされたGUIアプリケーション
- Get-MediaInfo.ps1によるPowerShell連携も可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MediaInfoラッパークラスの構造を理解。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MediaInfo.vb | `Source/General/MediaInfo.vb` | MediaInfoクラスの定義、P/Invoke宣言、情報取得メソッド |

**読解のコツ**: VB.NETのDllImport属性によるネイティブライブラリ呼び出しパターンを理解する。MediaInfo_Newでハンドル作成、MediaInfo_Openでファイルオープン、MediaInfo_Getで情報取得。

#### Step 2: エントリーポイントを理解する

メニューからの呼び出しを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | メニュー定義、MediaInfo表示コマンドの登録 |
| 2-2 | GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ShowMediaInfoコマンドの実装 |

**主要処理フロー**:
1. **MainForm.vb 4408行目付近**: メニュー項目「Media Info | MediaInfo.NET」の定義
2. **GlobalCommands.vb**: ShowMediaInfoNET()メソッドでMediaInfo.NET起動

#### Step 3: パッケージ定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Package.vb | `Source/General/Package.vb` | MediaInfo、MediaInfoNET、GetMediaInfoパッケージの定義 |

**主要処理フロー**:
- **255-262行目**: MediaInfo DLLパッケージ定義
- **264-271行目**: MediaInfo.NETパッケージ定義
- **273-280行目**: Get-MediaInfo.ps1パッケージ定義

### プログラム呼び出し階層図

```
MainForm (メインメニュー)
    │
    ├─ Tools > Media Info > MediaInfo.NET
    │      └─ GlobalCommands.ShowMediaInfoNET()
    │              └─ g.Execute(Package.MediaInfoNET.Path, filePath)
    │
    └─ Tools > Media Info > MediaInfo Folder View
           └─ GlobalCommands.ShowMediaInfoFolderView()
                   └─ PowerShell + Get-MediaInfo.ps1
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ファイルパス ───────────▶ MediaInfo.NET起動 ───▶ GUIウィンドウ
                                │
                                ▼
                         MediaInfo.dll
                                │
                                ▼
                         ファイル解析
                                │
                                ▼
                         メタデータ取得
                                │
                                ▼
                         情報整形・表示 ───▶ ユーザー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MediaInfo.vb | `Source/General/MediaInfo.vb` | ソース | MediaInfoラッパークラス |
| Package.vb | `Source/General/Package.vb` | ソース | パッケージ定義（MediaInfo、MediaInfo.NET） |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインメニュー定義 |
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | MediaInfo表示コマンド |
| MediaInfo.dll | `Support/MediaInfo.NET/MediaInfo.dll` | ライブラリ | ネイティブ解析ライブラリ |
| MediaInfoNET.exe | `Support/MediaInfo.NET/MediaInfoNET.exe` | 実行ファイル | GUI表示アプリケーション |
| Get-MediaInfo.ps1 | `Support/MediaInfo.NET/Get-MediaInfo.ps1` | スクリプト | PowerShell連携スクリプト |
