# 機能設計書 63-mkvinfo表示

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「mkvinfo表示」機能の設計仕様を定義する。この機能は、MKV（Matroska）ファイルの詳細な構造情報をmkvinfo（MKVToolNixの一部）を使用して表示する。

### 本機能の処理概要

**業務上の目的・背景**：MKVコンテナは複雑な構造を持ち、複数のビデオ、オーディオ、字幕トラックや添付ファイルを格納できる。エンコード作業やトラブルシューティングにおいて、MKVファイルの内部構造（トラック構成、コーデック情報、タグ、チャプター等）を詳細に把握することは重要である。本機能により、mkvinfoコマンドラインツールを活用してMKVファイルの詳細情報をターミナルに表示する。

**機能の利用シーン**：
- MKVファイルのトラック構成確認
- Demux対象トラックの特定
- MKVコンテナの問題診断
- メタデータ・タグ情報の確認

**主要な処理内容**：
1. ファイル選択ダイアログでMKVファイルを選択
2. mkvinfoコマンドの実行パスを取得（Package.mkvinfo）
3. ターミナル（PowerShell/Windows Terminal）でmkvinfo実行
4. 結果をターミナルウィンドウに表示

**関連システム・外部連携**：mkvinfo（MKVToolNixの一部）、ターミナルエミュレータ

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | MainForm | 主画面 | メニューからmkvinfo表示を呼び出し |
| - | OpenFileDialog | 参照画面 | MKVファイル選択 |
| - | Terminal | 結果表示画面 | mkvinfo出力表示 |

## 機能種別

情報表示 / 外部ツール実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FilePath | String | Yes | 解析対象のMKVファイルパス | .mkv拡張子、ファイル存在 |

### 入力データソース

- OpenFileDialogでユーザーが選択したファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイル構造情報 | Text | MKVファイルのセグメント、トラック構造 |
| トラック情報 | Text | ビデオ/オーディオ/字幕トラックの詳細 |
| タグ・チャプター | Text | メタデータ、チャプター情報 |

### 出力先

- ターミナルウィンドウ（標準出力）

## 処理フロー

### 処理シーケンス

```
1. メニューからmkvinfo表示を選択
   └─ Tools > Media Info > mkvinfo
2. OpenFileDialogでMKVファイル選択
   └─ フィルタ: MKV|*.mkv
3. ダイアログOK時にmkvinfo実行
   └─ g.RunCodeInTerminal()でターミナル起動
4. mkvinfoコマンドをファイルパスと共に実行
   └─ & '{Package.mkvinfo.Path}' '{dialog.FileName}'
5. ターミナルに結果表示
```

### フローチャート

```mermaid
flowchart TD
    A[mkvinfo表示選択] --> B[OpenFileDialog表示]
    B --> C{ファイル選択?}
    C -->|Yes| D[Package.mkvinfo.Path取得]
    C -->|No| Z[終了]
    D --> E[g.RunCodeInTerminal呼び出し]
    E --> F[ターミナル起動]
    F --> G[mkvinfoコマンド実行]
    G --> H[結果表示]
    H --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-63-01 | MKV限定 | MKVファイル（.mkv拡張子）のみ対象 | ファイル選択時 |
| BR-63-02 | ツール依存 | mkvinfoがインストールされている必要あり | コマンド実行時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Tool Not Found | mkvinfoが見つからない | MKVToolNixをインストール |
| - | File Error | ファイルが開けない | ファイルパス・権限を確認 |

### リトライ仕様

自動リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- mkvinfoの実行速度はファイルサイズに依存
- 通常は数秒以内に完了

## セキュリティ考慮事項

- ローカルファイルのみ対象
- 外部プロセス（mkvinfo）の実行

## 備考

- mkvinfoはMKVToolNixに含まれる
- mkvmerge、mkvextractと同じディレクトリに配置される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コマンド定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ShowMkvInfo()メソッドの実装 |

**読解のコツ**: Command属性付きのSubプロシージャがメニューコマンドとして公開される。

**主要処理フロー**:
- **572-581行目**: ShowMkvInfo() - OpenFileDialog表示、g.RunCodeInTerminal()呼び出し

#### Step 2: パッケージ定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Package.vb | `Source/General/Package.vb` | mkvinfoパッケージの定義 |

**主要処理フロー**:
- **712-728行目**: mkvinfoパッケージ定義、Siblings設定

#### Step 3: メニュー登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm.vb | `Source/Forms/MainForm.vb` | メニュー項目の登録 |

**主要処理フロー**:
- **4410行目**: "Apps|Media Info|mkvinfo"メニュー項目の登録

### プログラム呼び出し階層図

```
MainForm (メインメニュー)
    │
    └─ Apps > Media Info > mkvinfo
           └─ GlobalCommands.ShowMkvInfo()
                  │
                  ├─ OpenFileDialog (MKVファイル選択)
                  │
                  └─ g.RunCodeInTerminal()
                         └─ PowerShell/Terminal
                                └─ mkvinfo.exe (Package.mkvinfo.Path)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザー選択 ───────────▶ OpenFileDialog ───▶ ファイルパス
                                │
                                ▼
ファイルパス ───────────▶ mkvinfoコマンド生成
                                │
                                ▼
コマンド ───────────────▶ g.RunCodeInTerminal()
                                │
                                ▼
                         ターミナル起動 ───▶ mkvinfo出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | ShowMkvInfoコマンド |
| Package.vb | `Source/General/Package.vb` | ソース | mkvinfoパッケージ定義 |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メニュー登録 |
| mkvinfo.exe | `Support/MKVToolNix/mkvinfo.exe` | 実行ファイル | MKV解析ツール |
