# 機能設計書 65-テーマ設定

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「テーマ設定」機能の設計仕様を定義する。この機能は、アプリケーションのUI外観（色、フォント等）をカスタマイズするためのテーマ機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：長時間のエンコード作業において、目に優しいダークテーマや個人の好みに合わせたUI外観を選択できることは、作業効率と快適性の向上に寄与する。本機能により、ユーザーはライトテーマ、ダークテーマ等から好みの外観を選択できる。

**機能の利用シーン**：
- アプリケーション初回設定時のテーマ選択
- 作業環境（明るい部屋/暗い部屋）に応じたテーマ切り替え
- 個人の好みに応じたUI外観のカスタマイズ

**主要な処理内容**：
1. テーマ定義の読み込み（Theme.vb）
2. ThemeManagerによるテーマ管理
3. 現在のテーマの取得と適用
4. UIコントロールへの色・スタイル適用
5. ApplicationSettingsへのテーマ設定保存

**関連システム・外部連携**：特になし

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | MainForm | 主画面 | テーマ適用対象 |
| - | Settings Dialog | 設定画面 | テーマ選択UI |
| - | 全ダイアログ | 参照画面 | テーマ適用対象 |

## 機能種別

設定管理 / UI カスタマイズ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ThemeName | String | Yes | テーマ名 | 定義済みテーマ名であること |

### 入力データソース

- ApplicationSettings.ThemeNameプロパティ
- ユーザーによる設定画面での選択

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CurrentTheme | Theme | 現在適用中のテーマオブジェクト |

### 出力先

- 全フォーム・コントロールのUI表示
- ApplicationSettings（永続化）

## 処理フロー

### 処理シーケンス

```
1. ApplicationSettings.Init()でThemeNameを読み込み
   └─ デフォルトテーマ名: ThemeManager.DefaultThemeName
2. ThemeManager.SetCurrentTheme(themeName)を呼び出し
   └─ テーマ名からThemeオブジェクトを取得
3. ThemeManager.CurrentThemeに設定
   └─ 静的プロパティで全アプリケーションから参照可能
4. 各フォームでApplyTheme()を呼び出し
   └─ ThemeManager.CurrentThemeの色設定を適用
5. 設定変更時にg.SaveSettings()で永続化
```

### フローチャート

```mermaid
flowchart TD
    A[アプリケーション起動] --> B[ApplicationSettings.Init]
    B --> C[ThemeName読み込み]
    C --> D[ThemeManager.SetCurrentTheme]
    D --> E[Themesコレクションから検索]
    E --> F{テーマ存在?}
    F -->|Yes| G[CurrentThemeに設定]
    F -->|No| H[デフォルトテーマ使用]
    G --> I[フォーム表示]
    H --> I
    I --> J[ApplyTheme]
    J --> K[UI色設定適用]
    K --> L{設定変更?}
    L -->|Yes| M[新テーマ選択]
    L -->|No| Z[終了]
    M --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-01 | デフォルトテーマ | 設定が無い場合はデフォルトテーマを使用 | 初回起動時 |
| BR-65-02 | テーマ即時適用 | テーマ変更は即時にUIに反映される | テーマ選択時 |
| BR-65-03 | 一貫性 | 全フォーム・ダイアログに同一テーマを適用 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Theme Not Found | 指定テーマが存在しない | デフォルトテーマにフォールバック |

### リトライ仕様

自動リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- テーマ切り替え：即時反映（100ms以内）
- UI再描画：スムーズな遷移

## セキュリティ考慮事項

- ローカル設定のみ使用
- テーマ定義はアプリケーション内蔵

## 備考

- Themeクラスで各UI要素の色を定義
- ダークテーマは目に優しい設計

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Theme.vb | `Source/UI/Theme.vb` | Themeクラスの構造、色定義プロパティ |

**読解のコツ**: Themeクラスのネストクラス（General、MainForm、CropForm等）で各画面の色設定が定義されている。

#### Step 2: テーママネージャを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ThemeManager.vb | `Source/UI/ThemeManager.vb` | テーマ管理、CurrentTheme、SetCurrentTheme |

**主要処理フロー**:
- Themesプロパティ：利用可能なテーマのリスト
- CurrentThemeプロパティ：現在のテーマ
- SetCurrentTheme()メソッド：テーマ切り替え
- DefaultThemeName定数：デフォルトテーマ名

#### Step 3: 設定画面との連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | テーマ選択UIの実装 |

**主要処理フロー**:
- **284-291行目**: テーマ選択メニューの作成
- ThemeManager.Themesからテーマ名リストを取得
- theme.Button.ValueChangedActionでテーマ変更時の処理

#### Step 4: テーマ適用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MainForm_Assistant.vb | `Source/Forms/MainForm_Assistant.vb` | ApplyTheme()の呼び出し |

**主要処理フロー**:
- **11-14行目**: ThemeRefreshフラグでテーマ再適用
- **502-503行目**: laTipの背景色・文字色にテーマ色を適用

### プログラム呼び出し階層図

```
ApplicationSettings.Init()
    │
    └─ ThemeManager.SetCurrentTheme(s.ThemeName)
           │
           ├─ ThemeManager.Themes [テーマリスト]
           │
           └─ ThemeManager.CurrentTheme = selectedTheme
                  │
                  └─ 各フォーム.ApplyTheme()
                         │
                         ├─ ThemeManager.CurrentTheme.General
                         ├─ ThemeManager.CurrentTheme.MainForm
                         ├─ ThemeManager.CurrentTheme.CropForm
                         └─ ...
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ApplicationSettings
  .ThemeName ───────────▶ ThemeManager.SetCurrentTheme()
                                │
                                ▼
                         Themes.FirstOrDefault(name)
                                │
                                ▼
                         CurrentTheme設定
                                │
                                ▼
各フォーム.ApplyTheme() ───▶ UI色適用 ───▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Theme.vb | `Source/UI/Theme.vb` | ソース | テーマ定義クラス |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理 |
| ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | ソース | ThemeName保存 |
| MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | ソース | テーマ選択UI |
| MainForm_Assistant.vb | `Source/Forms/MainForm_Assistant.vb` | ソース | テーマ適用呼び出し |
