# 機能設計書 66-アシスタント機能

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「アシスタント機能」の設計仕様を定義する。この機能は、エンコード設定の問題点や不整合を検出し、ユーザーに警告・ガイダンスを提供するインテリジェントなヘルプシステムである。

### 本機能の処理概要

**業務上の目的・背景**：ビデオエンコードは多数の設定項目があり、設定ミスや非互換な組み合わせが品質問題や処理エラーの原因となる。本機能により、エンコード実行前に潜在的な問題を検出し、ユーザーに適切なアクションを促すことで、エンコード失敗や品質問題を未然に防止する。

**機能の利用シーン**：
- ソースファイル読み込み後の設定確認
- エンコード実行前の最終チェック
- 設定変更時のリアルタイム検証
- クロップ・リサイズ設定後の確認

**主要な処理内容**：
1. ソースファイル・ターゲット設定の整合性チェック
2. エンコーダー設定とコンテナ形式の互換性チェック
3. オーディオ設定の検証（ビットレート、チャンネル、コーデック互換性）
4. クロップ・リサイズ設定とDolby Vision設定の互換性チェック
5. スクリプトエラーの検出と表示
6. 警告・ブロックメッセージの表示とユーザーアクション誘導

**関連システム・外部連携**：特になし（アプリケーション内部機能）

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | MainForm | 主画面 | アシスタントパネル表示 |
| - | gbAssistant | UI部品 | 警告メッセージ表示エリア |
| - | laTip | UI部品 | ヒントテキスト表示 |
| - | bnNext | UI部品 | 「Add Job」ボタン |

## 機能種別

バリデーション / ユーザーガイダンス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| refreshScript | Boolean | No | スクリプト再同期フラグ | デフォルト: True |

### 入力データソース

- プロジェクト設定（p）
- エンコーダー設定
- オーディオプロファイル
- スクリプト情報（p.Script）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AssistantPassed | Boolean | 全チェックをパスしたかどうか |
| TipMessage | String | 表示するヒントメッセージ |
| AssistantClickAction | Action | クリック時のアクション |

### 出力先

- MainFormのアシスタントパネル（laTip、gbAssistant）
- bnNextボタンの有効/無効状態

## 処理フロー

### 処理シーケンス

```
1. Assistant()メソッド呼び出し
   └─ 設定変更時、フォーカス変更時等に自動呼び出し
2. スクリプト同期（refreshScript=Trueの場合）
   └─ p.Script.Synchronize()
3. 各種チェック処理を順次実行
   └─ ProcessTip()でヒント表示、Block()/Warn()で結果返却
4. 問題検出時は即座に警告表示して終了
   └─ AssistantPassed = False
5. 全チェックパス時はAdd Jobボタンを有効化
   └─ AssistantPassed = True, bnNext.Enabled = True
```

### フローチャート

```mermaid
flowchart TD
    A[Assistant呼び出し] --> B{SkipAssistant?}
    B -->|Yes| Z[Return False]
    B -->|No| C[テーマ更新チェック]
    C --> D[スクリプト同期]
    D --> E{ソースファイルあり?}
    E -->|No| F[ソースファイル要求Tip表示]
    E -->|Yes| G[タグファイル重複チェック]
    G --> H[カバーファイル名チェック]
    H --> I[エンコーダー設定チェック]
    I --> J[オーディオ設定チェック]
    J --> K[コンテナ互換性チェック]
    K --> L[アスペクト比チェック]
    L --> M[クロップ/リサイズチェック]
    M --> N[Dolby Visionチェック]
    N --> O[スクリプトエラーチェック]
    O --> P{全チェックOK?}
    P -->|Yes| Q[Add Job有効化]
    P -->|No| R[警告表示]
    Q --> Z
    F --> Z
    R --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-66-01 | ソース必須 | ソースファイルが未選択の場合はジョブ追加不可 | 常時 |
| BR-66-02 | パス同一禁止 | ソースとターゲットのパスが同一の場合はブロック | ターゲット設定時 |
| BR-66-03 | コンテナ互換性 | エンコーダー出力形式がコンテナでサポートされていること | エンコーダー/Muxer設定時 |
| BR-66-04 | 出力Mod制約 | 出力解像度がForcedOutputModで割り切れること | リサイズ設定時 |
| BR-66-05 | Dolby Vision制約 | Dolby Vision使用時はクロップ・リサイズに制約あり | Dolby Vision設定時 |
| BR-66-06 | VBV必須 | Dolby Vision使用時はVBV設定が必要 | x265 + Dolby Vision時 |

### 計算ロジック

- アスペクト比エラー = Calc.GetAspectRatioError()
- 許容範囲チェック: ae > p.MaxAspectRatioError OrElse ae < -p.MaxAspectRatioError

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Block | 致命的な設定エラー | 問題解決まで処理続行不可 |
| - | Warn | 警告（無視可能） | ユーザーに確認を促す |

### リトライ仕様

自動リトライは行わない。ユーザーが設定を修正して再確認。

## トランザクション仕様

該当なし

## パフォーマンス要件

- チェック処理：即時完了（100ms以内）
- UI更新：スムーズな表示

## セキュリティ考慮事項

- 入力検証のみ、外部通信なし

## 備考

- CanIgnoreTipフラグで警告の無視可否を制御
- AssistantClickActionでTipクリック時のアクションを指定可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm_Assistant.vb | `Source/Forms/MainForm_Assistant.vb` | Assistant()関数の全体フロー |

**読解のコツ**: ProcessTip()でヒント表示を判定し、Block()またはWarn()で結果を返す構造。各チェックは順次実行され、最初に引っかかったチェックで処理終了。

**主要処理フロー**:
- **8-24行目**: 初期化処理、スクリプト同期
- **125-131行目**: タグファイル重複チェック
- **133-141行目**: カバーファイル名チェック
- **154-166行目**: ソースファイル必須チェック
- **168-175行目**: パス同一チェック
- **177-189行目**: クロップリマインダー
- **207-251行目**: オーディオ設定チェック
- **253-257行目**: ファイル形式互換性チェック
- **265-273行目**: アスペクト比エラーチェック
- **342-376行目**: Dolby Visionクロップチェック
- **378-388行目**: Dolby Visionリサイズチェック
- **474-480行目**: スクリプトエラーチェック
- **490-505行目**: 全チェックOK時の処理

#### Step 2: ヘルパーメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ProcessTip(), Block(), Warn()の実装 |

### プログラム呼び出し階層図

```
MainForm (設定変更イベント)
    │
    └─ Assistant(refreshScript)
           │
           ├─ p.Script.Synchronize() [スクリプト同期]
           │
           ├─ ProcessTip(message) [各種チェック]
           │      │
           │      ├─ Block(title, controls...) [ブロック表示]
           │      │      └─ AssistantPassed = False
           │      │
           │      └─ Warn(title, action, controls...) [警告表示]
           │             └─ AssistantClickAction = action
           │
           └─ [全チェックOK]
                  ├─ gbAssistant.Text = "Add Job"
                  ├─ AssistantPassed = True
                  └─ bnNext.Enabled = True
```

### データフロー図

```
[入力]                    [処理]                           [出力]

プロジェクト設定(p) ───▶ Assistant()
                                │
                                ▼
スクリプト情報 ────────▶ 各種チェック処理
                                │
エンコーダー設定 ──────▶ 互換性検証
                                │
オーディオ設定 ────────▶ 設定値検証
                                │
                                ▼
                    ┌───────────┴───────────┐
                    ▼                       ▼
               問題検出                 全チェックOK
                    │                       │
                    ▼                       ▼
               Block/Warn              AssistantPassed=True
                    │                       │
                    ▼                       ▼
              laTip表示 ───▶ UI      bnNext有効 ───▶ UI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm_Assistant.vb | `Source/Forms/MainForm_Assistant.vb` | ソース | アシスタント処理メイン |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | ProcessTip/Block/Warn実装 |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクト設定 |
| VideoScript.vb | `Source/FrameServer/VideoScript.vb` | ソース | スクリプト情報 |
| Calc.vb | `Source/General/Calc.vb` | ソース | アスペクト比計算 |
