# 機能設計書 67-ログ表示

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「ログ表示」機能の設計仕様を定義する。この機能は、エンコード処理の実行ログを収集・表示・保存するための機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：エンコード処理は複数のツール（ffmpeg、x265、mkvmerge等）を連携して実行するため、処理結果やエラー情報を一元的に管理・表示することが重要である。本機能により、処理の進行状況確認、エラー診断、過去の処理履歴の参照が可能となる。

**機能の利用シーン**：
- エンコード実行中の進捗確認
- エラー発生時の原因調査
- 過去のエンコード履歴の確認
- サポート問い合わせ時の情報提供

**主要な処理内容**：
1. LogBuilderによるログメッセージの構築
2. LogFormによるログ表示UI
3. ログファイルへの出力・保存
4. ログローテーション（古いログの自動削除）
5. デバッグログの出力（設定有効時）

**関連システム・外部連携**：特になし

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | LogForm | 主画面 | ログ表示UI |
| - | ProcessingForm | 参照画面 | エンコード中のログ表示 |
| - | MainForm | 参照画面 | メニューからログ表示呼び出し |

## 機能種別

情報表示 / ログ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| LogFileNum | Integer | No | 保持するログファイル数 | デフォルト: 200 |
| WriteDebugLog | Boolean | No | デバッグログ出力フラグ | デフォルト: False |
| LogEventCommand | Boolean | No | イベントコマンドログ出力フラグ | デフォルト: False |

### 入力データソース

- 外部ツールの標準出力/標準エラー出力
- アプリケーション内部のログメッセージ
- ApplicationSettingsのログ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ログテキスト | String | ログメッセージ全文 |
| ログファイル | File | 保存されたログファイル |

### 出力先

- LogForm（画面表示）
- ログフォルダ（ファイル保存）

## 処理フロー

### 処理シーケンス

```
1. LogBuilder.Add()でログメッセージ追加
   └─ 各処理からログメッセージを収集
2. LogBuilder.ToString()でログ全文取得
   └─ 構造化されたログテキストを生成
3. LogForm.Show()でログ表示
   └─ ログ内容をUIに表示
4. ログファイルへの保存
   └─ エンコード完了時に自動保存
5. 古いログの削除（ローテーション）
   └─ LogFileNum以上のファイルを削除
```

### フローチャート

```mermaid
flowchart TD
    A[エンコード開始] --> B[LogBuilder初期化]
    B --> C[各処理実行]
    C --> D[LogBuilder.Add でログ追加]
    D --> E{処理継続?}
    E -->|Yes| C
    E -->|No| F[エンコード完了]
    F --> G[ログファイル保存]
    G --> H{ファイル数 > LogFileNum?}
    H -->|Yes| I[古いファイル削除]
    H -->|No| J[終了]
    I --> J

    K[ログ表示要求] --> L[LogForm.Show]
    L --> M[LogBuilder.ToString]
    M --> N[UI表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-67-01 | ログローテーション | LogFileNumを超えたログファイルは古い順に削除 | ログ保存時 |
| BR-67-02 | デバッグログ | WriteDebugLog=Trueの場合のみ詳細ログを出力 | 常時 |
| BR-67-03 | イベントログ | LogEventCommand=Trueの場合イベントコマンドをログ | イベント実行時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。ログはファイルとして保存。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Write Error | ログファイル書き込み失敗 | エラーメッセージ表示 |
| - | Delete Error | ログファイル削除失敗 | 警告表示、処理続行 |

### リトライ仕様

自動リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- ログ追加：即時（バッファリング使用）
- ファイル保存：非同期実行推奨
- UI表示：大量ログでもスムーズにスクロール

## セキュリティ考慮事項

- ローカルファイルのみ保存
- パスワード等の機密情報はマスキング推奨

## 備考

- ログフォルダはTools > Folders > Log Filesで開ける
- ログファイル形式はテキストファイル

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogBuilder.vb | `Source/General/LogBuilder.vb` | ログメッセージの構築クラス |

**読解のコツ**: Add()メソッドでログを追加し、ToString()で全文取得する構造。

#### Step 2: ログ表示UIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LogForm.vb | `Source/Forms/LogForm.vb` | ログ表示フォームの実装 |

#### Step 3: 設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | ログ関連設定 |

**主要処理フロー**:
- **63行目**: LogFileNum（保持するログファイル数）
- **62行目**: LogEventCommand（イベントコマンドログ出力）
- **118行目**: WriteDebugLog（デバッグログ出力）

#### Step 4: 設定UIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | ログ設定UI |

**主要処理フロー**:
- **58-74行目**: Logsページのログ設定項目

### プログラム呼び出し階層図

```
エンコード処理
    │
    ├─ LogBuilder.Add(message) [ログ追加]
    │
    └─ エンコード完了
           │
           ├─ LogBuilder.ToString() [ログ全文取得]
           │
           └─ ログファイル保存
                  │
                  └─ ログローテーション

ログ表示要求
    │
    └─ LogForm.Show()
           │
           └─ LogBuilder.ToString() [ログ表示]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

外部ツール出力 ──────────▶ LogBuilder.Add()
                                │
アプリケーションログ ────▶ StringBuilder蓄積
                                │
                                ▼
                         LogBuilder.ToString()
                                │
                    ┌───────────┴───────────┐
                    ▼                       ▼
              LogForm表示             ファイル保存
                    │                       │
                    ▼                       ▼
                 UI表示               ログフォルダ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogBuilder.vb | `Source/General/LogBuilder.vb` | ソース | ログ構築クラス |
| LogForm.vb | `Source/Forms/LogForm.vb` | ソース | ログ表示フォーム |
| ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | ソース | ログ設定 |
| MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | ソース | ログ設定UI |
