# 機能設計書 68-アプリケーション設定

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「アプリケーション設定」機能の設計仕様を定義する。この機能は、アプリケーション全体の動作を制御する設定項目の管理機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：StaxRipは多機能なエンコードアプリケーションであり、ユーザーの作業環境や好みに応じて様々な設定をカスタマイズできることが重要である。本機能により、一般設定、ログ設定、起動設定、システム設定、UI設定、フレームサーバー設定等を一元的に管理できる。

**機能の利用シーン**：
- アプリケーション初回セットアップ時
- 作業環境の最適化
- トラブルシューティング時の設定調整
- パフォーマンスチューニング

**主要な処理内容**：
1. SimpleSettingsFormによる設定ダイアログ表示
2. ApplicationSettingsオブジェクトへの設定バインディング
3. 設定変更の即時反映またはリスタート要求
4. 設定ファイルへの永続化（g.SaveSettings）
5. 設定のバージョン管理とマイグレーション

**関連システム・外部連携**：特になし

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Settings Dialog | 主画面 | 設定項目の表示・編集 |
| - | MainForm | 参照画面 | メニューから設定ダイアログ呼び出し |

## 機能種別

設定管理 / CRUD操作

## 入力仕様

### 入力パラメータ

主要な設定項目：

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AutoSaveProject | Boolean | No | プロジェクト自動保存 | - |
| ProjectsMruNum | Integer | No | MRUプロジェクト数 | 0-25 |
| ParallelProcsNum | Integer | No | 並列処理数 | 1-16 |
| ProcessPriority | ProcessPriorityClass | No | プロセス優先度 | Enum値 |
| ThemeName | String | No | テーマ名 | 定義済みテーマ |
| UIScaleFactor | Single | No | UIスケール | 0.3-3.0 |
| StartupTemplate | String | No | 起動テンプレート | ファイル存在 |
| CheckForUpdates | Boolean | No | 更新チェック | - |

### 入力データソース

- ApplicationSettings（s）オブジェクト
- ユーザーによるUI操作

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ApplicationSettings | Object | 更新された設定オブジェクト |

### 出力先

- 設定ファイル（永続化）
- アプリケーション動作への反映

## 処理フロー

### 処理シーケンス

```
1. ShowSettingsDialog()呼び出し
   └─ Tools > Settings メニューから
2. SimpleSettingsFormを生成
   └─ 各設定ページを動的に構築
3. ui.Store = sでApplicationSettingsをバインド
   └─ Field属性でプロパティ名を指定
4. 設定ページの構築
   └─ General, Logs, Startup, System, UI等のページ
5. ダイアログ表示・ユーザー操作
   └─ 各種設定コントロールの操作
6. OK時にui.Save()で設定保存
   └─ g.SaveSettings()で永続化
7. 必要に応じてリスタート要求
   └─ 一部設定は再起動が必要
```

### フローチャート

```mermaid
flowchart TD
    A[Settings呼び出し] --> B[SimpleSettingsForm生成]
    B --> C[設定ページ構築]
    C --> D[Generalページ]
    C --> E[Logsページ]
    C --> F[Startupページ]
    C --> G[Systemページ]
    C --> H[UIページ]
    C --> I[Frameserverページ]
    D --> J[ダイアログ表示]
    E --> J
    F --> J
    G --> J
    H --> J
    I --> J
    J --> K{OK?}
    K -->|Yes| L[ui.Save]
    K -->|No| M[キャンセル処理]
    L --> N[g.SaveSettings]
    N --> O{再起動必要?}
    O -->|Yes| P[再起動メッセージ]
    O -->|No| Q[設定反映]
    P --> R[終了]
    Q --> R
    M --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-68-01 | 即時反映 | テーマ変更等の一部設定は即時反映 | 対応設定変更時 |
| BR-68-02 | 再起動要求 | フレームサーバーモード等は再起動が必要 | 対応設定変更時 |
| BR-68-03 | バリデーション | 数値設定には範囲制限を適用 | 設定入力時 |
| BR-68-04 | Danger Zone | 危険な設定は別ページに分離して警告表示 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。設定はバイナリシリアライズでファイル保存。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Validation Error | 範囲外の値入力 | 入力を拒否、エラー表示 |
| - | Save Error | 設定ファイル書き込み失敗 | エラーメッセージ表示 |

### リトライ仕様

自動リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 設定ダイアログ表示：即時
- 設定保存：即時

## セキュリティ考慮事項

- ローカル設定ファイルのみ使用
- Danger Zone設定は明示的な警告付き

## 備考

- 設定変更履歴はVersionsディクショナリで管理
- SafeSerializationインターフェースでマイグレーション対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | 設定プロパティの定義、Init()でのデフォルト値設定 |

**読解のコツ**: PublicフィールドがUI設定項目として公開される。Check()メソッドでバージョン管理、Init()で初期化処理。

**主要処理フロー**:
- **9-122行目**: 設定プロパティの定義
- **136-376行目**: Init()メソッドでの初期化・マイグレーション

#### Step 2: 設定ダイアログUIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | 設定ダイアログの構築 |

**主要処理フロー**:
- **7-10行目**: ShowSettingsDialog()メソッド開始
- **11-12行目**: SimpleSettingsForm生成
- **16-57行目**: Generalページ
- **58-74行目**: Logsページ
- **76-110行目**: Startupページ
- **222-279行目**: Systemページ
- **281-426行目**: User Interfaceページ
- **428-448行目**: Frameserverページ
- **459-480行目**: Danger Zoneページ
- **483-518行目**: OK時の保存処理

### プログラム呼び出し階層図

```
MainForm (Tools > Settings)
    │
    └─ ShowSettingsDialog()
           │
           ├─ SimpleSettingsForm生成
           │      │
           │      ├─ ui.Store = s [ApplicationSettingsバインド]
           │      │
           │      ├─ ui.CreateFlowPage("General") [ページ作成]
           │      │      └─ ui.AddBool/AddNum/AddMenu等
           │      │
           │      └─ 他のページ...
           │
           ├─ form.ShowDialog()
           │
           └─ [OK時]
                  │
                  ├─ ui.Save()
                  ├─ g.SaveSettings()
                  └─ 再起動チェック
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ApplicationSettings(s) ───▶ SimpleSettingsForm
                                │
                                ▼
                         設定ページ構築
                                │
                                ▼
ユーザー操作 ──────────▶ UI コントロール
                                │
                                ▼
                         ui.Save()
                                │
                                ▼
                         g.SaveSettings() ───▶ 設定ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | ソース | 設定プロパティ定義 |
| MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | ソース | 設定ダイアログUI |
| SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | ソース | 設定フォーム基底クラス |
| SimpleUI.vb | `Source/UI/SimpleUI.vb` | ソース | 設定UIビルダー |
