# 機能設計書 69-プロジェクトオプション

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「プロジェクトオプション」機能の設計仕様を定義する。この機能は、個々のエンコードプロジェクトに固有の設定を管理する。

### 本機能の処理概要

**業務上の目的・背景**：アプリケーション全体の設定とは別に、プロジェクト（エンコードジョブ）ごとに異なる設定を保持する必要がある。例えば、アニメと実写で異なるクロップ設定、映画とTV番組で異なるアスペクト比設定など、コンテンツタイプに応じた設定をプロジェクトテンプレートとして保存・再利用できる。

**機能の利用シーン**：
- エンコード開始前の詳細設定
- プロジェクトテンプレートの作成・編集
- 特定コンテンツタイプ向けの設定カスタマイズ
- 出力品質・サイズの調整

**主要な処理内容**：
1. SimpleSettingsFormによるオプションダイアログ表示
2. Projectオブジェクト（p）へのプロパティバインディング
3. 画像設定（クロップ、リサイズ、アスペクト比）
4. ビデオ設定（デmux、HDR、フレームレート）
5. オーディオ設定（優先言語、デmuxモード）
6. 字幕設定（抽出、変換、ハードコード）
7. パス設定（ターゲットフォルダ、一時ファイル）
8. サムネイル設定

**関連システム・外部連携**：特になし

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Project Options Dialog | 主画面 | プロジェクトオプション表示・編集 |
| - | MainForm | 参照画面 | メニュー/F9キーからダイアログ呼び出し |

## 機能種別

設定管理 / CRUD操作

## 入力仕様

### 入力パラメータ

主要な設定項目：

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AutoResizeImage | Integer | No | 自動リサイズサイズ | 0=無効 |
| ForcedOutputMod | Integer | No | 出力Mod値 | 2,4,8,16 |
| CropLeft/Right/Top/Bottom | Integer | No | クロップ値 | 0-9999 |
| PreferredAudio | String | No | 優先オーディオ言語 | - |
| PreferredSubtitles | String | No | 優先字幕言語 | - |
| DefaultTargetFolder | String | No | 出力フォルダ | マクロ使用可 |
| Thumbnailer | Boolean | No | サムネイル自動生成 | - |

### 入力データソース

- Projectオブジェクト（p）
- ユーザーによるUI操作

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Project | Object | 更新されたプロジェクト設定 |

### 出力先

- プロジェクトファイル（.srip）
- テンプレートファイル

## 処理フロー

### 処理シーケンス

```
1. ShowOptionsDialog()呼び出し
   └─ Project > Options (F9) メニューから
2. SimpleSettingsFormを生成
   └─ 「Project Options」タイトル
3. ui.Store = pでProjectオブジェクトをバインド
   └─ Field属性でプロパティ名を指定
4. 設定ページの構築
   └─ Image, Video, Audio, Subtitles, Paths等
5. ダイアログ表示・ユーザー操作
   └─ 各種設定コントロールの操作
6. OK時にui.Save()で設定保存
   └─ Projectオブジェクトに反映
7. Assistant()で設定検証
   └─ 設定の整合性チェック
```

### フローチャート

```mermaid
flowchart TD
    A[Options呼び出し F9] --> B[SimpleSettingsForm生成]
    B --> C[設定ページ構築]
    C --> D[Imageページ]
    C --> E[Videoページ]
    C --> F[Audioページ]
    C --> G[Subtitlesページ]
    C --> H[Pathsページ]
    C --> I[Thumbnailsページ]
    C --> J[Assistantページ]
    D --> K[ダイアログ表示]
    E --> K
    F --> K
    G --> K
    H --> K
    I --> K
    J --> K
    K --> L{OK?}
    L -->|Yes| M[ui.Save]
    L -->|No| N[キャンセル]
    M --> O[Assistant呼び出し]
    O --> P[終了]
    N --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-69-01 | テンプレート保存 | File > Save Project As Templateで保存可能 | 常時 |
| BR-69-02 | 起動テンプレート | Settings > Startupで起動時テンプレート指定可能 | 常時 |
| BR-69-03 | クロップ自動補正 | AutoCorrectCropValuesでYUV互換に自動調整 | クロップ設定時 |
| BR-69-04 | Mod制約 | ForcedOutputModで出力解像度の制約を設定 | リサイズ時 |

### 計算ロジック

- アスペクト比計算: Calc.GetSourceDAR(), Calc.GetTargetDAR()
- 自動クロップ: AutoCropMode設定に基づく

## データベース操作仕様

本機能はデータベースを使用しない。プロジェクトはファイルとして保存。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Validation Error | 不正な値入力 | 入力を拒否、エラー表示 |
| - | Path Error | 不正なパス指定 | 警告表示 |

### リトライ仕様

自動リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 設定ダイアログ表示：即時
- 設定保存：即時

## セキュリティ考慮事項

- ローカルファイルのみ使用

## 備考

- プロジェクトオプションはテンプレートとして保存・共有可能
- マクロ（%source_dir%等）が各種パス設定で使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | Projectクラスのプロパティ定義 |

**読解のコツ**: Projectクラスのプロパティがプロジェクトオプションの設定項目に対応。

#### Step 2: 設定ダイアログUIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm_ShowOptions.vb | `Source/Forms/MainForm_ShowOptions.vb` | プロジェクトオプションダイアログの構築 |

**主要処理フロー**:
- **7-9行目**: ShowOptionsDialog()オーバーロード
- **11-17行目**: SimpleSettingsForm生成、説明テキスト
- **22行目**: ui.Store = pでProjectバインド
- **25-52行目**: Imageページ
- **55-92行目**: Image | Aspect Ratioページ
- **95-150行目**: Image | Cropページ
- **303-378行目**: Videoページ
- **381-452行目**: Audioページ
- **455-527行目**: Subtitlesページ
- **576-833行目**: Thumbnailsページ
- **768-833行目**: Pathsページ
- **981-1010行目**: Assistantページ

### プログラム呼び出し階層図

```
MainForm (Project > Options / F9)
    │
    └─ ShowOptionsDialog(pagePath)
           │
           ├─ SimpleSettingsForm生成
           │      │
           │      ├─ ui.Store = p [Projectバインド]
           │      │
           │      ├─ ui.CreateFlowPage("Image") [ページ作成]
           │      │      └─ ui.AddNum/AddBool/AddMenu等
           │      │
           │      └─ 他のページ...
           │
           ├─ form.ShowDialog()
           │
           └─ [OK時]
                  │
                  ├─ ui.Save()
                  └─ Assistant()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Project(p) ────────────▶ SimpleSettingsForm
                                │
                                ▼
                         設定ページ構築
                                │
                                ▼
ユーザー操作 ──────────▶ UI コントロール
                                │
                                ▼
                         ui.Save()
                                │
                                ▼
                         Project更新 ───▶ .sripファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm_ShowOptions.vb | `Source/Forms/MainForm_ShowOptions.vb` | ソース | オプションダイアログUI |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクト設定クラス |
| SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | ソース | 設定フォーム基底クラス |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メニュー定義、F9キーバインド |
