# 機能設計書 7-eac3to Demux

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるeac3to Demux機能の設計仕様を記述する。M2TSファイルからビデオ、オーディオ、字幕、チャプターストリームを抽出する機能である。Blu-ray/DVDサポート機能とは異なり、単体のM2TSファイルを対象とする。

### 本機能の処理概要

**業務上の目的・背景**：M2TS（MPEG-2 Transport Stream）はBlu-rayや一部のカメラで使用される高品質ビデオ形式である。本機能はeac3toツールを使用して、M2TSファイルから各ストリームを効率的に抽出する。Blu-rayディスク構造を経由しない直接的なM2TSファイル処理を提供する。

**機能の利用シーン**：
- 単体M2TSファイルからのビデオストリーム抽出
- M2TSファイルからの複数オーディオトラック抽出
- M2TSファイルからの字幕抽出
- M2TSファイルからのチャプター抽出

**主要な処理内容**：
1. eac3toFormダイアログでストリーム選択
2. ソースファイルをダイアログに設定
3. eac3to実行（GetArgsで引数構築）
4. 抽出結果をプロジェクトに反映
5. 選択言語をPreferredAudioに追加

**関連システム・外部連携**：
- eac3to：M2TSストリーム抽出
- MediaInfo：メディア情報取得

**権限による制御**：特になし。ファイルシステムへの読み書きアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | Demux処理の起動 |
| - | eac3toForm | ストリーム選択 | M2TSストリーム選択・抽出設定 |

## 機能種別

Demux処理 / ストリーム抽出

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sourceFile | String | Yes | M2TSファイルパス | 拡張子チェック（m2ts） |

### 入力データソース

- ソースファイル：プロジェクトのSourceFile
- 設定：eac3toFormダイアログでの選択

### 対応入力形式

- M2TS

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビデオストリーム | File | H264/MKV/M2V形式 |
| オーディオストリーム | File | 各種形式（m4a/ac3/dts/flac等） |
| 字幕ストリーム | File | SUP形式 |
| チャプター | File | _chapters.txt |

### 出力先

- eac3toFormで指定したOutputFolder
- デフォルトはプロジェクト一時ディレクトリ

## 処理フロー

### 処理シーケンス

```
1. eac3toForm表示
   └─ M2TSFile設定
   └─ teTempDir設定
2. ストリーム解析（eac3toForm内部）
   └─ eac3to -progressnumbers
3. ストリーム選択
   └─ ビデオ出力形式選択
   └─ オーディオ選択（チェックボックス）
   └─ 字幕選択（チェックボックス）
   └─ チャプター抽出設定
4. Demux実行
   └─ GetArgs()で引数構築
   └─ eac3to実行
5. プロジェクト更新
   └─ SourceFile更新
   └─ PreferredAudio更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{NoDialogs/BatchMode?}
    B -->|Yes| C[終了]
    B -->|No| D[eac3toForm作成]
    D --> E[M2TSFile設定]
    E --> F[teTempDir設定]
    F --> G[ShowDialog]
    G --> H{OK?}
    H -->|No| I[AbortException]
    H -->|Yes| J[GetArgs構築]
    J --> K[eac3to実行]
    K --> L{成功?}
    L -->|No| M[例外処理]
    M --> N[AbortException]
    L -->|Yes| O[PreferredAudio更新]
    O --> P{Video出力?}
    P -->|Yes| Q[SourceFile更新]
    P -->|No| R[終了]
    Q --> R
    I --> R
    C --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 入力形式 | m2ts拡張子のみ対応 | 常時 |
| BR-002 | ダイアログ必須 | NoDialogs/BatchMode時はスキップ | 常時 |
| BR-003 | 言語追加 | 選択オーディオの言語をPreferredAudioに追加 | Demux完了時 |
| BR-004 | ソース更新 | ビデオ出力時にSourceFile/TempDirを更新 | ビデオ抽出時 |

### 計算ロジック

- 出力ファイルパス：OutputFolder + SourceFile.Base + "." + 出力形式

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-001 | DialogCancel | ダイアログキャンセル | AbortException |
| E-002 | eac3toError | eac3to実行失敗 | 例外表示、AbortException |

### リトライ仕様

リトライ処理は行わない。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- ストリーム抽出：ファイルサイズに依存

## セキュリティ考慮事項

- ファイルパスのエスケープ処理
- 一時ディレクトリへの書き込み権限確認

## 備考

- デフォルトではActive=False（オプション機能）
- eac3toFormでの詳細設定はBlu-ray/DVDサポート機能と共通
- OutputExtensionsは{"h264", "mkv", "m2v"}

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

eac3toDemuxerクラスとその継承関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Demux.vb | `Source/General/Demux.vb` | Demuxer基底クラス（7-108行目） |
| 1-2 | Demux.vb | `Source/General/Demux.vb` | eac3toDemuxerクラス（182-242行目） |

**読解のコツ**: InputExtensions={"m2ts"}、OutputExtensions={"h264", "mkv", "m2v"}に注目。

#### Step 2: エントリーポイントを理解する

eac3toDemuxerのRunメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Demux.vb | `Source/General/Demux.vb` | eac3toDemuxer.Run（191-235行目） |

**主要処理フロー**:
1. **192-194行目**: NoDialogs/BatchMode時の早期リターン
2. **196-199行目**: eac3toForm作成とパラメータ設定
3. **200-216行目**: eac3to実行（Proc使用）
4. **218-222行目**: PreferredAudio更新
5. **224-229行目**: SourceFile/TempDir更新

#### Step 3: eac3toFormを理解する

eac3toFormの構造とGetArgsメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | GetArgs（967-1030行目） |

**主要処理フロー**:
- **967行目**: GetArgsメソッド定義
- **972-978行目**: ビデオストリーム出力引数
- **991-1007行目**: オーディオストリーム出力引数
- **1009-1027行目**: 字幕・チャプター出力引数

### プログラム呼び出し階層図

```
eac3toDemuxer.Run(proj)
    │
    ├─ NoDialogs/BatchMode チェック
    │
    └─ eac3toForm.ShowDialog()
           │
           ├─ eac3toForm.M2TSFile = proj.SourceFile
           │
           ├─ eac3toForm.teTempDir.Text = proj.TempDir
           │
           └─ Dialog OK時
                  │
                  ├─ eac3toForm.GetArgs()
                  │      └─ コマンドライン引数構築
                  │
                  ├─ Proc.Start() [eac3to実行]
                  │
                  ├─ PreferredAudio更新
                  │      └─ 選択オーディオ言語追加
                  │
                  └─ SourceFile/TempDir更新
```

### データフロー図

```
[入力]                      [処理]                        [出力]

M2TSファイル ────────▶ eac3toForm表示
                              │
                              ▼
                     ストリーム選択（UI）
                              │
                              ▼
                     GetArgs()構築 ──────────▶ eac3toコマンドライン
                              │
                              ▼
                     eac3to実行
                              │
                              ▼
                     ストリーム抽出 ─────────▶ .h264/.mkv/.m2v
                                              .ac3/.dts/.flac
                                              .sup
                                              _chapters.txt
                              │
                              ▼
                     Project更新 ────────────▶ SourceFile
                                              PreferredAudio
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Demux.vb | `Source/General/Demux.vb` | ソース | eac3toDemuxerクラス定義（182-242行目） |
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | M2TSストリーム選択ダイアログ |
| Package.vb | `Source/General/Package.vb` | ソース | eac3toパッケージ定義 |
