# 機能設計書 70-設定リセット

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「設定リセット」機能の設計仕様を定義する。この機能は、特定の設定項目を初期値（デフォルト値）に戻すための機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：アプリケーションの設定が複雑になったり、問題が発生したりした場合に、特定の設定項目を初期状態に戻すことでトラブルシューティングや設定の再構築が容易になる。全設定を一括リセットするのではなく、カテゴリ別に選択的にリセットできることで、必要な設定は保持しつつ問題のある設定のみを初期化できる。

**機能の利用シーン**：
- 設定の不整合によるエラー発生時
- 新バージョンへのアップデート後の設定問題
- 特定のプロファイル（エンコーダー、オーディオ等）の初期化
- メニューカスタマイズの初期化

**主要な処理内容**：
1. SelectionBoxによるリセット対象選択ダイアログ表示
2. ApplicationSettings.Versionsから設定カテゴリ一覧を取得
3. 選択されたカテゴリのバージョンを-1に設定
4. 次回起動時にInit()でデフォルト値に復元
5. リセット完了メッセージの表示

**関連システム・外部連携**：特になし

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | SelectionBox | 主画面 | リセット対象選択ダイアログ |
| - | MainForm | 参照画面 | メニューからダイアログ呼び出し |

## 機能種別

設定管理 / データ初期化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SelectedValue | String | Yes | リセット対象の設定カテゴリ名 | Versionsに存在すること |

### 入力データソース

- ApplicationSettings.Versionsディクショナリ
- ユーザーによる選択操作

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Versions(key) | Integer | -1（リセットフラグ） |

### 出力先

- ApplicationSettings.Versions

## 処理フロー

### 処理シーケンス

```
1. ResetSettings()呼び出し
   └─ Tools > Advanced > Reset Settings... メニューから
2. SelectionBox生成
   └─ タイトル: "Reset Settings"
3. ApplicationSettings.Versionsからカテゴリ一覧取得
   └─ 新しいApplicationSettingsを一時生成してInit()
4. カテゴリ一覧をソートして選択肢として追加
   └─ sb.AddItem(category)
5. ダイアログ表示・ユーザー選択
   └─ sb.Show()
6. OK時に選択カテゴリのバージョンを-1に設定
   └─ s.Versions(sb.SelectedValue) = -1
7. 完了メッセージ表示
   └─ 「次回起動時にリセットされます」
```

### フローチャート

```mermaid
flowchart TD
    A[Reset Settings呼び出し] --> B[SelectionBox生成]
    B --> C[一時ApplicationSettings生成]
    C --> D[Init でVersions取得]
    D --> E[カテゴリ一覧をソート]
    E --> F[選択肢として追加]
    F --> G[ダイアログ表示]
    G --> H{カテゴリ選択?}
    H -->|Yes| I[Versions(key) = -1]
    H -->|No| J[キャンセル]
    I --> K[完了メッセージ]
    K --> L[終了]
    J --> L

    M[次回起動時] --> N[ApplicationSettings.Init]
    N --> O{Version = -1?}
    O -->|Yes| P[デフォルト値復元]
    O -->|No| Q[既存値使用]
    P --> R[Version更新]
    R --> S[終了]
    Q --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-70-01 | 遅延リセット | リセットは次回起動時に実行される | 常時 |
| BR-70-02 | カテゴリ別 | 設定カテゴリ単位でリセット可能 | 常時 |
| BR-70-03 | バージョンフラグ | Version=-1で次回Init時にデフォルト復元 | Init実行時 |
| BR-70-04 | バックアップ保持 | 一部設定ではBackupプレフィックス付きで旧設定を保持 | 対応カテゴリ |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Cancel | ユーザーがキャンセル | 処理終了 |

### リトライ仕様

自動リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 設定リセット操作：即時
- 次回起動時の復元：ApplicationSettings初期化時間内

## セキュリティ考慮事項

- ローカル設定のみ影響
- 確認ダイアログによる誤操作防止

## 備考

- リセット対象カテゴリ例：
  - Video Encoder Profiles
  - Audio Profiles
  - AviSynth Filter Profiles
  - VapourSynth Filter Profiles
  - Menu in main window
  - Menu in crop dialog
  - etc.

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リセットコマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ResetSettings()メソッドの実装 |

**読解のコツ**: SelectionBoxでカテゴリを選択し、Versions(key)=-1を設定する単純な構造。

**主要処理フロー**:
- **918行目**: ResetSettings()メソッド定義
- **919-920行目**: SelectionBox生成、タイトル設定
- **924-925行目**: 一時ApplicationSettings生成、Init()呼び出し
- **927-929行目**: Versionsからカテゴリ取得、AddItem
- **931行目**: ソート
- **933-936行目**: OK時にVersion=-1設定、完了メッセージ

#### Step 2: バージョン管理メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | Check()メソッドとバージョン管理 |

**主要処理フロー**:
- **114行目**: Versionsプロパティ定義
- **132-134行目**: Check()メソッド呼び出し
- **SafeSerialization.Check()**: バージョン比較ロジック

#### Step 3: メニュー登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm.vb | `Source/Forms/MainForm.vb` | メニュー項目の登録 |

**主要処理フロー**:
- **4390行目**: "Tools|Advanced|Reset Settings..."メニュー登録

### プログラム呼び出し階層図

```
MainForm (Tools > Advanced > Reset Settings...)
    │
    └─ GlobalCommands.ResetSettings()
           │
           ├─ SelectionBox<String>生成
           │
           ├─ ApplicationSettings一時生成
           │      └─ Init() [Versions取得]
           │
           ├─ Versions.Keysをリスト化
           │      └─ sb.AddItem(category)
           │
           ├─ sb.Show() [ユーザー選択]
           │
           └─ [OK時]
                  │
                  ├─ s.Versions(sb.SelectedValue) = -1
                  │
                  └─ MsgInfo("次回起動時にリセット")

[次回起動時]
    │
    └─ ApplicationSettings.Init()
           │
           └─ Check(property, key, version)
                  │
                  └─ [Version=-1] デフォルト値復元
```

### データフロー図

```
[入力]                    [処理]                           [出力]

メニュー選択 ───────────▶ SelectionBox表示
                                │
                                ▼
ApplicationSettings
  .Versions ───────────▶ カテゴリ一覧表示
                                │
                                ▼
ユーザー選択 ──────────▶ Versions(key) = -1
                                │
                                ▼
                         設定ファイル保存

[次回起動時]

設定ファイル ──────────▶ Init()
                                │
                                ▼
Version = -1 ──────────▶ デフォルト値復元
                                │
                                ▼
                         設定適用 ───▶ アプリケーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | ResetSettings()コマンド |
| ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | ソース | バージョン管理、Check()、Init() |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メニュー登録 |
| SafeSerialization.vb | `Source/General/SafeSerialization.vb` | ソース | Check()実装 |
| SelectionBox.vb | `Source/UI/SelectionBox.vb` | ソース | 選択ダイアログUI |
