# 機能設計書 71-アップデート確認

## 概要

本ドキュメントは、StaxRipアプリケーションの「アップデート確認」機能について、処理内容、入出力仕様、およびコードリーディングガイドを記載する設計書である。

### 本機能の処理概要

アップデート確認機能は、StaxRipの新バージョンが公開されているかをGitHubリポジトリに問い合わせ、ユーザーに更新を促す機能である。

**業務上の目的・背景**：ビデオエンコードソフトウェアは、コーデックやツールの更新が頻繁に行われるため、最新版を使用することがエンコード品質と互換性の維持に重要である。本機能により、ユーザーは手動でリリースページを確認することなく、アプリケーション起動時または明示的な操作により最新バージョンの有無を確認できる。

**機能の利用シーン**：
- アプリケーション起動時の自動バージョンチェック
- ユーザーがメニューから手動でアップデート確認を実行した場合
- 新機能やバグ修正を含む最新版の取得が必要な場合

**主要な処理内容**：
1. 現在のアプリケーションバージョンを取得
2. GitHubリリースページから最新バージョン情報を取得
3. バージョン比較を実行し、新バージョンがあるかを判定
4. 新バージョンがある場合、変更履歴（CHANGELOG）を取得・表示
5. ユーザーにリリースページを開くか、更新をスキップするか選択させる

**関連システム・外部連携**：
- GitHub API（github.com/staxrip/staxrip/releases）
- GitHub Raw Content（raw.githubusercontent.com）- CHANGELOG取得用

**権限による制御**：特にロールや権限による制御はなく、すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | UpdateForm | 主画面 | 新バージョンのダウンロードと更新進捗表示 |

## 機能種別

データ連携 / UI表示 / ファイルダウンロード

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| force | Boolean | No | 強制的にアップデート確認を実行するフラグ | - |
| x64 | Boolean | No | 64ビット版を対象とするかのフラグ（デフォルト: True） | - |

### 入力データソース

- アプリケーション設定（s.CheckForUpdates, s.CheckForUpdatesDismissed, s.CheckForUpdatesLastRequest）
- アセンブリ情報（Assembly.GetEntryAssembly.GetName.Version）
- GitHubリリースページHTML

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| latestVersion | Version | 検出された最新バージョン |
| releaseType | String | リリースタイプ（"release"） |
| downloadUri | String | ダウンロードURL |
| fileName | String | ダウンロードファイル名 |
| changelogContent | String | 変更履歴の内容 |

### 出力先

- TaskDialog（ユーザーへの通知ダイアログ）
- UpdateForm（ダウンロード進捗表示画面）
- アプリケーション設定（s.CheckForUpdatesLastRequest, s.CheckForUpdatesDismissed）

## 処理フロー

### 処理シーケンス

```
1. 自動チェック条件の確認
   └─ s.CheckForUpdates設定とforce引数を確認
2. チェック間隔の計算
   └─ インストールからの経過時間に基づいて間隔を決定（1〜12時間）
3. 最後のチェックからの経過確認
   └─ diffHoursToCheck以上経過していればチェック実行
4. GitHubリリースページの取得
   └─ HttpClientでHTMLを取得
5. バージョン情報の抽出
   └─ 正規表現でバージョンタグを解析
6. 新バージョンの有無を判定
   └─ 現在バージョンと比較
7. 変更履歴の取得
   └─ CHANGELOG.mdをダウンロードして解析
8. ユーザーへの通知
   └─ TaskDialogで選択肢を提示
9. ユーザー操作の処理
   └─ リリースページを開く or 更新をスキップ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{自動チェック有効?}
    B -->|No & force=false| Z[終了]
    B -->|Yes or force=true| C[バージョン初回実行日時設定]
    C --> D[チェック間隔計算]
    D --> E{間隔経過?}
    E -->|No & force=false| Z
    E -->|Yes or force=true| F[GitHubリリースページ取得]
    F --> G[バージョン情報抽出]
    G --> H{新バージョンあり?}
    H -->|No| I[更新なしメッセージ]
    I --> Z
    H -->|Yes| J{既にスキップ済み?}
    J -->|Yes & force=false| Z
    J -->|No or force=true| K[CHANGELOG取得]
    K --> L[TaskDialog表示]
    L --> M{ユーザー選択}
    M -->|Open| N[リリースページを開く]
    M -->|Dismiss| O[スキップバージョン記録]
    M -->|Cancel| Z
    N --> Z
    O --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-71-01 | チェック間隔の動的調整 | インストールから24時間未満は1時間間隔、48時間未満は2時間間隔、72時間未満は4時間間隔、96時間未満は6時間間隔、それ以降は12時間間隔でチェック | 自動チェック実行時 |
| BR-71-02 | スキップバージョン管理 | ユーザーが「Dismiss」を選択したバージョンは、次回以降のチェックでは通知をスキップ | force=falseの場合のみ |
| BR-71-03 | 変更履歴の表示上限 | CHANGELOGから最大30項目の変更点を表示 | TaskDialog表示時 |

### 計算ロジック

**チェック間隔の計算**:
```
hours = (現在日時 - 初回実行日時).TotalHours
diffHoursToCheck =
  hours < 24 の場合: 1時間
  hours < 48 の場合: 2時間
  hours < 72 の場合: 4時間
  hours < 96 の場合: 6時間
  それ以外: 12時間
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能ではデータベース操作は行わない。設定はアプリケーション設定ファイル経由で永続化される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | WebException | GitHubへの接続失敗 | 例外をキャッチして処理を終了（サイレント） |
| - | HttpRequestException | HTTPリクエスト失敗 | 例外をキャッチして処理を終了（サイレント） |

### リトライ仕様

リトライは実装されていない。ネットワークエラー時は次回チェック時に再試行される。

## トランザクション仕様

トランザクション管理は不要（外部API呼び出しのみ）。

## パフォーマンス要件

- HTTPリクエストは非同期（Async/Await）で実行され、UIスレッドをブロックしない
- ダウンロードサイズが大きい場合はUpdateFormで進捗表示

## セキュリティ考慮事項

- HTTPS通信のみを使用
- ダウンロードURLはGitHubの公式ドメインに限定
- ユーザーの明示的な同意なくダウンロードや実行は行わない

## 備考

- 開発環境（g.IsDevelopmentPC = True）ではアップデート確認の質問ダイアログが表示されない
- UpdateFormは従来のダウンロード方式を使用し、StaxRipUpdateクラスは新しいHTTPClient方式を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アップデート確認機能では、バージョン情報とリリース情報を管理するタプル構造が使用される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | latestVersionsリスト（タプル構造）の定義を確認 |

**読解のコツ**: VB.NETのタプル構造`(Version As Version, ReleaseType As String, SourceSite As String, DownloadUri As String, FileName As String)`がバージョン情報を保持する。

#### Step 2: エントリーポイントを理解する

処理の起点となるメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | CheckForUpdateAsyncメソッド（41-142行目）がメインエントリーポイント |

**主要処理フロー**:
1. **41-42行目**: force引数とs.CheckForUpdates設定の確認
2. **44行目**: SetFirstRunOnCurrentVersion呼び出し
3. **46-56行目**: チェック間隔の計算と経過確認
4. **58-80行目**: GitHubリリースページの取得とバージョン解析
5. **82-136行目**: 新バージョン検出時のTaskDialog表示処理

#### Step 3: UI層を理解する

ダウンロード進捗を表示するUIコンポーネント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UpdateForm.vb | `Source/Forms/UpdateForm.vb` | 従来のダウンロード処理とProgressBar更新 |
| 3-2 | UpdateForm.Designer.vb | `Source/Forms/UpdateForm.Designer.vb` | UI構成（ScrappyProgressBar）の確認 |

**主要処理フロー**:
- **5-12行目**: フォームロード時のUpdate処理呼び出し
- **14-36行目**: バージョン比較とダウンロード実行
- **38-43行目**: ダウンロード進捗のProgressBar更新

#### Step 4: 設定質問ダイアログを理解する

初回実行時のユーザー同意確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | ShowUpdateQuestionメソッド（20-39行目） |

**主要処理フロー**:
- **21行目**: 開発PCおよび質問済みフラグの確認
- **22-37行目**: TaskDialogでYes/No/Ask me laterの選択肢を表示
- **35-36行目**: ユーザー選択に基づく設定更新

### プログラム呼び出し階層図

```
CheckForUpdateAsync (StaxRipUpdate.vb:41)
    │
    ├─ SetFirstRunOnCurrentVersion (StaxRipUpdate.vb:13)
    │      └─ s.FirstRunOnVersion設定更新
    │
    ├─ HttpClient.GetAsync (github.com/staxrip/staxrip/releases)
    │      └─ HTMLコンテンツ取得
    │
    ├─ Regex.Matches (バージョンタグ解析)
    │      └─ latestVersionsリスト構築
    │
    ├─ HttpClient.GetAsync (raw.githubusercontent.com/CHANGELOG.md)
    │      └─ 変更履歴取得
    │
    └─ TaskDialog表示
           ├─ "Open release page" → ShellExecute
           └─ "Dismiss" → s.CheckForUpdatesDismissed更新

UpdateForm (UpdateForm.vb)
    │
    └─ Update_Load
           │
           ├─ バージョン比較
           │
           └─ WebClient.DownloadFileTaskAsync
                  └─ ProgressChangedイベント → ProgressBar更新
```

### データフロー図

```
[入力]                       [処理]                           [出力]

アセンブリバージョン ───▶ CheckForUpdateAsync ───▶ TaskDialog表示
                              │                        │
s.CheckForUpdates ───────────▶│                        └──▶ ブラウザ起動
                              │
s.CheckForUpdatesDismissed ──▶│                     設定更新
                              │                        │
GitHubリリースHTML ─────────▶ バージョン解析 ─────▶ s.CheckForUpdatesLastRequest
                              │
CHANGELOG.md ──────────────▶ 変更点抽出 ─────────▶ s.CheckForUpdatesDismissed
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | ソース | アップデート確認のメインロジック |
| UpdateForm.vb | `Source/Forms/UpdateForm.vb` | ソース | ダウンロード進捗表示UI |
| UpdateForm.Designer.vb | `Source/Forms/UpdateForm.Designer.vb` | ソース | UpdateFormのUIデザイナー定義 |
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | 外部ツールのアップデート（関連機能） |
