# 機能設計書 72-ヘルプ表示

## 概要

本ドキュメントは、StaxRipアプリケーションの「ヘルプ表示」機能について、処理内容、入出力仕様、およびコードリーディングガイドを記載する設計書である。

### 本機能の処理概要

ヘルプ表示機能は、StaxRipの各機能・設定項目についてのヘルプドキュメントをHTMLベースのビューアで表示する機能である。コンテキストに応じたヘルプ情報を動的に生成し、ユーザーが操作に迷った際のガイダンスを提供する。

**業務上の目的・背景**：ビデオエンコードソフトウェアは多くの設定項目とパラメータを持ち、初心者から上級者まで幅広いユーザーが利用する。各設定項目の意味と効果を理解することは、適切なエンコード結果を得るために重要である。本機能により、ユーザーはアプリケーション内で即座にヘルプを参照でき、外部ドキュメントを検索する手間を省ける。

**機能の利用シーン**：
- 各種設定項目で右クリックしてコンテキストヘルプを表示
- F1キーによるヘルプ要求
- メニューからのヘルプ表示
- 外部ツール（ffmpeg、x265等）のヘルプ参照

**主要な処理内容**：
1. ヘルプコンテンツの取得（TipProvider、StringPairList）
2. HTMLドキュメントの動的生成（HelpDocument）
3. WebBrowserコントロールでのHTML表示
4. 外部リンクのブラウザ委譲処理
5. ショートカットキー一覧の表示

**関連システム・外部連携**：
- System.Windows.Forms.WebBrowser（HTML表示）
- 外部Webブラウザ（http/httpsリンク）
- 外部ツールのヘルプ（ffmpeg、x265等のコマンドラインヘルプ）

**権限による制御**：特にロールや権限による制御はなく、すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | HelpForm | 主画面 | HTMLベースのヘルプドキュメント表示 |

## 機能種別

UI表示 / ドキュメント生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| heading | String | Yes | ヘルプドキュメントのタイトル | - |
| tips | StringPairList | No | 表示するヘルプ項目のリスト（名前と説明のペア） | - |
| summary | String | No | 概要説明テキスト | - |

### 入力データソース

- TipProvider（各UI要素に設定されたヘルプテキスト）
- CustomMenu（メニュー項目のショートカットキー情報）
- Package.Items（外部ツールのヘルプ情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTMLドキュメント | String | 生成されたHTMLコンテンツ |
| 一時ファイル | File | Tempフォルダに作成されるHTMファイル |

### 出力先

- HelpForm（WebBrowserコントロール）
- 一時ディレクトリ（Folder.Temp）にHTMファイルとして保存

## 処理フロー

### 処理シーケンス

```
1. HelpForm インスタンス生成
   └─ InitializeComponent、アイコン設定、サイズ復元
2. HelpDocument の初期化
   └─ 一時ファイルパスの生成（GUID使用）
3. HTMLコンテンツの構築
   └─ WriteStart: HTML/HEAD/BODY開始タグとスタイル
   └─ WriteParagraph: 概要テキスト
   └─ WriteTips: ヘルプ項目（H3+P形式）
   └─ WriteTable: ショートカットキー一覧
4. HTMLの書き出しと表示
   └─ WriteDocument: WebBrowserにナビゲート
5. ユーザー操作
   └─ 外部リンククリック時はブラウザに委譲
   └─ ESCキーで閉じる
6. フォーム終了時
   └─ 一時ファイルの削除（Disposed時）
```

### フローチャート

```mermaid
flowchart TD
    A[ヘルプ要求] --> B{呼び出し元}
    B -->|TipProvider右クリック| C[g.ShowHelp呼び出し]
    B -->|F1キー| D[HelpRequested イベント]
    B -->|メニュー| E[ヘルプメニュー選択]

    C --> F[MsgInfo表示]
    D --> G[HelpForm生成]
    E --> G

    G --> H[HelpDocument初期化]
    H --> I[WriteStart - HTML開始]
    I --> J[WriteTips - ヘルプ項目]
    J --> K[WriteTable - ショートカット]
    K --> L[WriteDocument]
    L --> M[WebBrowser表示]

    M --> N{リンククリック?}
    N -->|外部URL| O[ブラウザで開く]
    N -->|内部| M

    M --> P[フォーム閉じる]
    P --> Q[一時ファイル削除]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-72-01 | 外部リンク委譲 | http/httpsで始まるURLはWebBrowserではなく既定ブラウザで開く | リンクナビゲーション時 |
| BR-72-02 | マークアップ変換 | MediaWiki形式のリンク`[URL テキスト]`をHTMLの`<a>`タグに変換 | テキスト出力時 |
| BR-72-03 | 強調変換 | `'''テキスト'''`を`<b>テキスト</b>`に変換 | テキスト出力時 |
| BR-72-04 | ヘルプ項目ソート | ヘルプ項目はアルファベット順にソートして表示 | WriteTips呼び出し時 |
| BR-72-05 | タイトル末尾整形 | タイトル末尾の`.`や`:`を自動削除 | g.ShowHelp呼び出し時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能ではデータベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IOException | 一時ファイル書き込み失敗 | 例外発生（通常は発生しない） |

### リトライ仕様

リトライは実装されていない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- HTMLドキュメントの生成は即時（ミリ秒単位）
- WebBrowser表示も即時

## セキュリティ考慮事項

- 外部URLはShellExecuteで開くため、ユーザーの操作なく任意のURLを開くことはない
- 一時ファイルはアプリケーション終了時に削除

## 備考

- HelpFormはFormBaseを継承し、RestoreClientSizeでサイズ復元
- WebBrowserのテキストサイズはWebBrowserHelp.ResetTextSizeでリセット
- ダークテーマに対応したCSSスタイルが適用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ヘルプ機能では、StringPairListがヘルプ項目（名前と説明のペア）を保持する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | StringPairList, StringPairクラスの定義確認 |

**読解のコツ**: StringPairは単純なName/Valueペアで、ヘルプの見出しと本文を格納する。

#### Step 2: エントリーポイントを理解する

処理の起点となるHelpFormクラス。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HelpForm.vb | `Source/Forms/HelpForm.vb` | HelpFormクラスの構造（1-114行目） |

**主要処理フロー**:
1. **47-51行目**: コンストラクタでInitializeComponent、RestoreClientSize、アイコン設定
2. **53-68行目**: Docプロパティ - HelpDocumentのレイジー初期化
3. **70-84行目**: ShowDialogオーバーロード - ヘルプ表示のエントリーポイント
4. **102-106行目**: Showメソッド - WriteDocument呼び出し

#### Step 3: HTML生成ロジックを理解する

動的HTMLドキュメント生成の詳細。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | HelpDocumentクラス（439-719行目） |

**主要処理フロー**:
- **445-447行目**: コンストラクタ - パス設定
- **449-510行目**: WriteStart - HTML開始タグ、CSSスタイル定義
- **512-518行目**: WriteParagraph - 段落出力
- **537-551行目**: WriteElement - 要素出力とマークアップ変換
- **553-569行目**: ConvertChars - 特殊文字エスケープ
- **571-618行目**: ConvertMarkup - MediaWikiリンクとボールド変換
- **620-637行目**: WriteTips - ヘルプ項目リスト出力
- **671-719行目**: WriteTable - テーブル形式出力

#### Step 4: コンテキストヘルプ（TipProvider）を理解する

UI要素に設定されたヘルプテキストの管理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | TipProvider.vb | `Source/UI/TipProvider.vb` | TipProviderクラス全体（1-193行目） |

**主要処理フロー**:
- **50-53行目**: SetTipText - ヘルプテキスト設定
- **82-97行目**: Init - ツールチップ初期化と右クリックハンドラ登録
- **99-105行目**: TipMouseDown - 右クリック時のヘルプ表示
- **107-110行目**: ShowHelp - g.ShowHelp呼び出し
- **161-191行目**: GetTips - 表示可能なヘルプ項目収集

#### Step 5: グローバルヘルプ関数を理解する

g.ShowHelpメソッドの実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | ShowHelpメソッド（1009-1015行目） |

**主要処理フロー**:
- **1009-1015行目**: タイトル整形とMsgInfo呼び出し

### プログラム呼び出し階層図

```
[ヘルプ表示の呼び出し経路]

1. TipProvider経由（右クリック）
   TipMouseDown (TipProvider.vb:99)
       │
       └─ ShowHelp (TipProvider.vb:107)
              │
              └─ g.ShowHelp (GlobalClass.vb:1009)
                     │
                     └─ MsgInfo（簡易ダイアログ）

2. F1キー/ヘルプメニュー経由
   HelpRequested イベント
       │
       └─ HelpForm.ShowDialog (HelpForm.vb:70)
              │
              ├─ HelpDocument.WriteStart (General.vb:449)
              │      └─ XmlTextWriter で HTML生成
              │
              ├─ HelpDocument.WriteTips (General.vb:620)
              │      └─ ヘルプ項目をH3+P形式で出力
              │
              ├─ HelpDocument.WriteTable (General.vb:671)
              │      └─ ショートカットキーをテーブル形式で出力
              │
              └─ HelpForm.Show (HelpForm.vb:102)
                     │
                     └─ WriteDocument (General.vb)
                            │
                            └─ Browser.Navigate（HTMLファイル）
```

### データフロー図

```
[入力]                       [処理]                           [出力]

TipProvider               HelpForm.ShowDialog              WebBrowser
(ヘルプテキスト) ─────────▶ HelpDocument ─────────────▶ (HTML表示)
                              │
                              ▼
                         WriteStart
                         (HTML開始)
                              │
                              ▼
                         WriteTips
                         (ヘルプ項目)
                              │
                              ▼
                         WriteTable
                         (ショートカット)
                              │
                              ▼
                         一時ファイル
                         (Temp/*.htm)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HelpForm.vb | `Source/Forms/HelpForm.vb` | ソース | ヘルプ表示フォーム |
| General.vb | `Source/General/General.vb` | ソース | HelpDocumentクラス（HTML生成） |
| TipProvider.vb | `Source/UI/TipProvider.vb` | ソース | コンテキストヘルプ管理 |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | g.ShowHelpメソッド |
| UI Help.vb | `Source/UI/UI Help.vb` | ソース | WebBrowserHelperクラス |
