# 機能設計書 8-DGIndex/D2V Witch

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるDGIndex/D2V Witch機能の設計仕様を記述する。MPEG-2ビデオソース（DVD VOB、放送TS等）をデマルチプレクスし、フレームサーバー（AviSynth/VapourSynth）で読み込み可能なD2Vインデックスファイルを生成する機能である。

### 本機能の処理概要

**業務上の目的・背景**：MPEG-2はDVD-VideoやSD/HDテレビ放送で使用される基本的なビデオコーデックである。MPEG-2ビデオをAviSynth/VapourSynthで直接処理するには、D2V（DVD2AVI）形式のインデックスファイルが必要となる。本機能はDGIndexまたはD2V Witchを使用して、MPEG-2ソースからD2Vインデックスを生成し、同時にオーディオストリームをデマルチプレクスする。

**機能の利用シーン**：
- DVD VOBファイルのエンコード準備
- 放送録画TS/M2TSのエンコード準備
- MPEG-2ビデオファイルのインデックス生成
- レガシーMPGファイルの処理

**主要な処理内容**：
1. DGIndex/D2V Witchの選択・実行
2. MPEG-2ビデオのインデックス作成（D2Vファイル生成）
3. オーディオストリームのデマルチプレクス
4. ソースフィルター（MPEG2Source/D2VSource/d2v.Source）との連携

**関連システム・外部連携**：
- DGIndex：Donald Graffの MPEG-2デコーダ/インデクサー
- D2V Witch：VapourSynth用D2Vインデクサー
- AviSynth MPEG2Source/D2VSource：D2Vファイル読み込みフィルター
- VapourSynth d2v.Source：D2Vファイル読み込みプラグイン

**権限による制御**：特になし。ファイルシステムへの読み書きアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | Demux処理の起動 |

## 機能種別

Demux処理 / インデックス生成 / MPEG-2処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sourceFiles | String() | Yes | MPEG-2ソースファイルパス | 拡張子チェック |

### 入力データソース

- ソースファイル：プロジェクトのSourceFile/SourceFiles
- マクロ展開：%source_files%で複数ファイル対応

### 対応入力形式

- MPG/MPEG
- VOB
- M2TS
- M2V
- MTS
- M2T

### 対応入力フォーマット

- MPEG-2

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| D2Vインデックス | File | .d2vファイル（フレーム情報） |
| オーディオストリーム | File | デマルチプレクスされたオーディオ |
| ログファイル | File | _dg.log（DGIndex使用時） |

### 出力先

- プロジェクト一時ディレクトリ（p.TempDir）

## 処理フロー

### 処理シーケンス（DGIndex）

```
1. DGIndex実行
   └─ -i %source_files% -ia 2 -fo 0 -yr 1 -tn 1 -om 2 -drc 2 -dsd 0 -dsa 0
   └─ -o "%temp_file%" -hide -exit
2. ファイルリネーム
   └─ SourceFile.log -> _dg.log
   └─ .demuxed.m2v -> .m2v
3. タイムスタンプ抽出（MKV時）
   └─ mkvextract timestamps_v2
```

### 処理シーケンス（D2V Witch）

```
1. D2V Witch実行
   └─ --audio-ids all --output "%temp_file%.d2v" %source_files%
2. タイムスタンプ抽出（MKV時）
   └─ mkvextract timestamps_v2
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{どのDemuxer?}
    B -->|DGIndex| C[DGIndex実行]
    B -->|D2V Witch| D[D2V Witch実行]
    C --> E[ログファイルリネーム]
    E --> F[M2Vファイルリネーム]
    F --> G{MKVソース?}
    D --> G
    G -->|Yes| H{VFR/Always?}
    G -->|No| I[終了]
    H -->|Yes| J[mkvextract timestamps_v2]
    H -->|No| I
    J --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 入力形式 | mpg、mpeg、vob、m2ts、m2v、mts、m2t拡張子対応 | 常時 |
| BR-002 | 入力フォーマット | MPEG-2フォーマットのみ | 常時 |
| BR-003 | 出力形式 | D2V形式 | 常時 |
| BR-004 | ソースフィルター | MPEG2Source/D2VSource/d2v.Source | フレームサーバー設定時 |
| BR-005 | DGIndexデフォルト | DGIndexがデフォルトでActive | 常時 |
| BR-006 | D2V Witchオプション | D2V WitchはデフォルトでActive=False | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-001 | ToolNotFound | DGIndex/D2V Witchが見つからない | パッケージ確認を促す |
| E-002 | ProcessError | プロセス実行エラー | エラーログ出力 |

### リトライ仕様

リトライ処理は行わない。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- インデックス生成：ファイルサイズに依存
- DGIndexはIntegerPercentOutput形式で進捗表示

## セキュリティ考慮事項

- ファイルパスのエスケープ処理
- 一時ディレクトリへの書き込み権限確認

## 備考

- DGIndexオプション：-ia 2（オーディオ抽出）、-fo 0（フィールド順序自動）、-yr 1（YUV範囲）、-tn 1（テレシネ検出）、-om 2（出力モード）、-drc 2（DRC）
- D2V Witchオプション：--audio-ids all（全オーディオ抽出）
- DGIndexNVはDGIndexとは別扱い

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CommandLineDemuxerクラスとDemuxer定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Demux.vb | `Source/General/Demux.vb` | Demuxer基底クラス（7-108行目） |
| 1-2 | Demux.vb | `Source/General/Demux.vb` | CommandLineDemuxerクラス（110-179行目） |
| 1-3 | Demux.vb | `Source/General/Demux.vb` | GetDefaults内のDGIndex/D2V Witch定義（86-103行目） |

**読解のコツ**: CommandLineDemuxerはCommand/Argumentsプロパティでコマンドラインを定義。

#### Step 2: DGIndex定義を理解する

DGIndex Demuxerの設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Demux.vb | `Source/General/Demux.vb` | DGIndex定義（85-93行目） |

**DGIndex設定詳細**:
- **Name**: "DGIndex: Demux & Index MPEG-2"
- **InputExtensions**: {"mpg", "mpeg", "vob", "m2ts", "m2v", "mts", "m2t"}
- **OutputExtensions**: {"d2v"}
- **InputFormats**: {"mpeg2"}
- **Command**: %app_path:DGIndex%
- **Arguments**: -i %source_files% -ia 2 -fo 0 -yr 1 -tn 1 -om 2 -drc 2 -dsd 0 -dsa 0 -o "%temp_file%" -hide -exit
- **SourceFilters**: {"MPEG2Source", "D2VSource", "d2v.Source"}

#### Step 3: D2V Witch定義を理解する

D2V Witch Demuxerの設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Demux.vb | `Source/General/Demux.vb` | D2V Witch定義（94-103行目） |

**D2V Witch設定詳細**:
- **Name**: "D2V Witch: Demux & Index MPEG-2"
- **Active**: False（オプション）
- **Command**: cmd.exe
- **Arguments**: /S /C """%app_path:D2V Witch%" --audio-ids all --output "%temp_file%.d2v" %source_files%""

#### Step 4: Run処理を理解する

CommandLineDemuxerのRun処理とDGIndex固有処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Demux.vb | `Source/General/Demux.vb` | CommandLineDemuxer.Run（129-170行目） |

**主要処理フロー**:
- **131-141行目**: DGIndex/D2V Witch判定とPackage設定
- **148-151行目**: DGIndex固有のファイルリネーム処理
- **154-169行目**: MKVソースのタイムスタンプ抽出

### プログラム呼び出し階層図

```
CommandLineDemuxer.Run(proj)
    │
    ├─ Macro.Expand(Command + Arguments)
    │      └─ %app_path:DGIndex% / %app_path:D2V Witch%展開
    │      └─ %source_files% / %temp_file%展開
    │
    ├─ DGIndex判定
    │      └─ proc.Package = Package.DGIndex
    │      └─ proc.IntegerPercentOutput = True
    │
    ├─ D2V Witch判定
    │      └─ proc.Package = Package.D2VWitch
    │      └─ proc.SkipString = "%"
    │
    ├─ Proc.Start()
    │
    ├─ DGIndex固有処理
    │      └─ ログファイルリネーム（.log -> _dg.log）
    │      └─ M2Vファイルリネーム（.demuxed.m2v -> .m2v）
    │
    └─ MKVタイムスタンプ抽出（条件付き）
           └─ mkvextract timestamps_v2
```

### データフロー図

```
[入力]                      [処理]                        [出力]

MPG/VOB/M2TS ────────▶ DGIndex / D2V Witch
                              │
                              ▼
                     MPEG-2パース
                              │
                              ├───────────────────▶ .d2v（インデックス）
                              │
                              └───────────────────▶ オーディオストリーム
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Demux.vb | `Source/General/Demux.vb` | ソース | CommandLineDemuxer/DGIndex/D2V Witch定義 |
| Package.vb | `Source/General/Package.vb` | ソース | DGIndex/D2VWitchパッケージ定義 |
| Macro.vb | `Source/General/Macro.vb` | ソース | マクロ展開処理 |
