# 機能設計書 9-チャプター抽出

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるチャプター抽出機能の設計仕様を記述する。各種コンテナ形式からチャプター情報を抽出し、エンコード後のファイルに再適用するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：チャプター情報はDVD/Blu-rayや一部の動画ファイルに含まれるシーン区切り情報である。エンコード時にこの情報を保持することで、再生時のシーン選択やスキップ機能を維持できる。本機能は、ソースファイルからチャプター情報を抽出し、出力ファイルのMuxing時に組み込む。

**機能の利用シーン**：
- Blu-rayディスクからのチャプター抽出（eac3to経由）
- MKVファイルからのチャプター抽出（mkvextract chapters）
- MP4ファイルからのチャプター抽出（MP4Box -dump-chap-ogg）
- 抽出チャプターのMux（mkvmerge/MP4Box）

**主要な処理内容**：
1. 各Demuxerでのチャプター抽出処理
2. チャプターファイル形式変換（XML/OGG/テキスト）
3. Mux時のチャプター組み込み

**関連システム・外部連携**：
- mkvextract chapters：MKVチャプター抽出
- MP4Box -dump-chap-ogg：MP4チャプター抽出
- eac3to：Blu-rayチャプター抽出
- mkvmerge --chapters：MKVチャプターMux
- MediaInfo：チャプター存在確認

**権限による制御**：特になし。ファイルシステムへの読み書きアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | チャプター抽出設定 |
| - | StreamDemuxForm | ストリーム選択 | cbDemuxChaptersチェックボックス |
| - | eac3toForm | Blu-ray Demux | cbChaptersチェックボックス |

## 機能種別

データ抽出 / メタデータ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sourceFile | String | Yes | ソースファイルパス | チャプター存在確認 |
| demuxChapters | Boolean | Yes | チャプター抽出フラグ | - |

### 入力データソース

- プロジェクト設定：p.DemuxChapters
- StreamDemuxForm：cbDemuxChapters.Checked
- eac3toForm：cbChapters.Checked

### 対応チャプター形式

- Matroskaチャプター（XML形式）
- OGGチャプター（テキスト形式）
- Blu-rayチャプター

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| XMLチャプター | File | _chapters.xml（Matroska形式） |
| OGGチャプター | File | _chapters.txt（OGG形式） |

### 出力先

- プロジェクト一時ディレクトリ（proj.TempDir）

## 処理フロー

### 処理シーケンス（MKV）

```
1. チャプター存在確認
   └─ mkvmerge --identifyで"Chapters: "確認
2. XMLチャプター抽出
   └─ mkvextract chapters _chapters.xml
3. OGGチャプター抽出
   └─ mkvextract chapters --simple _chapters.txt
```

### 処理シーケンス（MP4）

```
1. チャプター存在確認
   └─ MediaInfo.GetMenu("Chapters_Pos_End") - GetMenu("Chapters_Pos_Begin") > 0
2. OGGチャプター抽出
   └─ MP4Box -dump-chap-ogg _chapters.txt
```

### 処理シーケンス（Blu-ray/eac3to）

```
1. ストリーム解析
   └─ eac3to -progressnumbers
2. チャプターストリーム検出
   └─ stream.IsChapters判定
3. チャプター抽出
   └─ eac3to ID: _chapters.txt
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{ソース形式?}
    B -->|MKV| C[mkvmerge --identify]
    B -->|MP4| D[MediaInfo.GetMenu]
    B -->|Blu-ray| E[eac3to解析]
    C --> F{Chapters存在?}
    D --> G{Pos確認}
    E --> H{IsChapters?}
    F -->|Yes| I[mkvextract chapters XML]
    F -->|No| J[終了]
    G -->|Yes| K[MP4Box -dump-chap-ogg]
    G -->|No| J
    H -->|Yes| L[eac3to抽出]
    H -->|No| J
    I --> M[mkvextract chapters --simple]
    M --> J
    K --> J
    L --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 存在確認必須 | チャプターが存在する場合のみ抽出 | 常時 |
| BR-002 | 両形式出力（MKV） | XML形式とOGG形式の両方を出力 | MKVソース |
| BR-003 | OGG形式（MP4） | OGG形式のみ出力 | MP4ソース |
| BR-004 | 設定保存（eac3to） | cbChapters.Checkedを"demux Blu-ray chapters"設定として保存 | eac3toForm |

### 計算ロジック

- チャプター存在判定（MP4）：Chapters_Pos_End - Chapters_Pos_Begin > 0

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-001 | NoChapters | チャプター情報なし | スキップ |
| E-002 | ExtractError | 抽出エラー | ログ出力 |

### リトライ仕様

リトライ処理は行わない。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- チャプター抽出：瞬時（メタデータのみ）

## セキュリティ考慮事項

- ファイルパスのエスケープ処理

## 備考

- mkvextract終了コード0,1,2を許容
- XMLチャプターはMatroska仕様準拠
- OGGチャプターはシンプルテキスト形式（--simpleオプション）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: MKVチャプター抽出を理解する

mkvDemuxerでのチャプター抽出処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Demux.vb | `Source/General/Demux.vb` | mkvDemuxer.Runのチャプター処理（756-780行目） |

**主要処理フロー**:
- **756行目**: demuxChapters && stdout.Contains("Chapters: ")で存在確認
- **757-767行目**: XMLチャプター抽出（mkvextract chapters _chapters.xml）
- **769-779行目**: OGGチャプター抽出（mkvextract chapters --simple _chapters.txt）

#### Step 2: MP4チャプター抽出を理解する

MP4BoxDemuxerでのチャプター抽出処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Demux.vb | `Source/General/Demux.vb` | MP4BoxDemuxer.Runのチャプター処理（577-589行目） |

**主要処理フロー**:
- **577-578行目**: Chapters_Pos_End - Chapters_Pos_Begin > 0で存在確認
- **580-588行目**: MP4Box -dump-chap-ogg実行

#### Step 3: Blu-rayチャプター抽出を理解する

eac3toFormでのチャプター抽出処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | GetArgsのチャプター処理（1022-1026行目） |

**主要処理フロー**:
- **841行目**: stream.IsChaptersで判定
- **1022-1026行目**: GetArgsでチャプター出力引数追加

### プログラム呼び出し階層図

```
[MKVチャプター抽出]
mkvDemuxer.Run(proj)
    │
    ├─ stdout.Contains("Chapters: ")
    │
    ├─ mkvextract chapters _chapters.xml
    │
    └─ mkvextract chapters --simple _chapters.txt

[MP4チャプター抽出]
MP4BoxDemuxer.Run(proj)
    │
    ├─ MediaInfo.GetMenu("Chapters_Pos_End/Begin")
    │
    └─ MP4Box -dump-chap-ogg _chapters.txt

[Blu-rayチャプター抽出]
eac3toForm.GetArgs()
    │
    └─ stream.IsChapters && cbChapters.Checked
           └─ ID: _chapters.txt
```

### データフロー図

```
[入力]                      [処理]                        [出力]

MKVファイル ────────▶ mkvextract chapters
                              │
                              ├───────────────────▶ _chapters.xml
                              │
                              └───────────────────▶ _chapters.txt

MP4ファイル ────────▶ MP4Box -dump-chap-ogg
                              │
                              └───────────────────▶ _chapters.txt

Blu-ray ──────────▶ eac3to
                              │
                              └───────────────────▶ _chapters.txt
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Demux.vb | `Source/General/Demux.vb` | ソース | mkvDemuxer/MP4BoxDemuxerチャプター処理 |
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | Blu-rayチャプター抽出 |
| StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | ソース | cbDemuxChaptersチェックボックス |
| Misc.vb | `Source/General/Misc.vb` | ソース | MediaInfo.GetMenuメソッド |
