---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-ソースファイル読み込み

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の5秒以内**：根拠不足
  2. **ISO形式のWindows 8以降対応**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb` - Projectクラス定義（SourceFile、SourceWidth等のフィールド）
- E-02: `Source/Forms/MainForm.vb` - MainFormクラス（tbSourceFile定義）
- E-03: `Source/General/GlobalCommands.vb` - LoadSourceFileコマンド（545-547行目）
- E-04: `Source/General/Demux.vb` - Demuxer基底クラスとファイル形式定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.1定義）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソースファイル読み込み機能はビデオ/オーディオファイルを読み込みプロジェクトに設定する | E-05 | ○ |
| C-02 | 対応形式はMKV、MP4、M2TS、AVI、VOB等 | E-05 | ○ |
| C-03 | MainFormのtbSourceFileからソースファイルを読み込む | E-02, E-06 | ○ |
| C-04 | ProjectクラスにSourceFile、SourceWidth等のプロパティが存在 | E-01 | ○ |
| C-05 | GlobalCommands.LoadSourceFile()が存在する | E-03 | ○ |
| C-06 | MainForm.OpenVideoSourceFile()が呼び出される | E-03 | ○ |
| C-07 | MediaInfoによるファイルメタデータ解析を行う | E-04 | ○ |
| C-08 | SourceWidth、SourceHeight等が119-136行目に定義 | E-01 | ○ |
| C-09 | LoadSourceFileは545-547行目に定義 | E-03 | ○ |
| C-10 | g.SetTempDir()で一時ディレクトリを設定 | E-02 | ○ |
| C-11 | ApplicationEvent.AfterSourceLoadedイベントが発火する | E-02 | ○ |
| C-12 | ドラッグ&ドロップでファイルを読み込める | E-02 | ○ |
| C-13 | コマンドライン引数でファイルパスを渡せる | E-03 | ○ |
| C-14 | ファイル存在確認のバリデーションが行われる | E-03 | ○ |
| C-15 | 対応形式のチェックが行われる | E-04 | ○ |
| C-16 | VFRファイルは追加処理が必要 | E-04 | ○ |
| C-17 | ファイル解析は5秒以内で完了する | **根拠なし** | △ |
| C-18 | ISO形式はWindows 8以降でマウント対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（5秒以内）の根拠となるドキュメントまたはコードが見つからない
  - 候補：要件定義書 / パフォーマンステスト結果 / 開発者コメント
- Windows 8以降のISO対応に関する根拠
  - 候補：Windows API仕様書 / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本的な説明は正確
- 1: 中リスク - パフォーマンス要件は実測値で検証必要
- 0: 低リスク - 対応ファイル形式はコードベースで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Project.vbのSourceFile関連プロパティ定義を確認
- [ ] MainForm.OpenVideoSourceFile()の実装詳細を確認
- [ ] MediaInfo連携部分のエラーハンドリングを確認
- [ ] パフォーマンス要件の妥当性を実測で検証
