---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-タイムスタンプ抽出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - mkvDemuxer.Runタイムスタンプ処理（782-797行目）
- E-02: `Source/General/Demux.vb` - CommandLineDemuxer.Runタイムスタンプ処理（154-169行目）
- E-03: `Source/General/Project.vb` - ExtractTimestampsプロパティ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.10定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mkvextract timestamps_v2でタイムスタンプ抽出 | E-01, E-02 | ○ |
| C-02 | MKVファイルのみ対応 | E-01, E-02 | ○ |
| C-03 | ExtractTimestamps != Neverで有効化 | E-01, E-02 | ○ |
| C-04 | Always または VFRで抽出 | E-01, E-02 | ○ |
| C-05 | FrameRate_Mode="VFR"でVFR判定 | E-01 | ○ |
| C-06 | SourceFrameRateMode="VFR"でVFR判定 | E-02 | ○ |
| C-07 | MediaInfo.GetVideo("StreamOrder")で順序取得 | E-01, E-02 | ○ |
| C-08 | 出力ファイル名は_timestamps.txt | E-01, E-02 | ○ |
| C-09 | mkvextract終了コード0,1,2を許容 | E-01, E-02 | ○ |
| C-10 | p.ExtractTimestampsプロパティが存在 | E-03 | ○ |
| C-11 | mkvDemuxerでタイムスタンプ抽出を実装 | E-01 | ○ |
| C-12 | CommandLineDemuxerでタイムスタンプ抽出を実装 | E-02 | ○ |
| C-13 | SourceFile.EndsWithEx(".mkv")でMKV判定 | E-01, E-02 | ○ |
| C-14 | UTF-8エンコーディング使用 | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - タイムスタンプ抽出はシンプルなメタデータ操作
- 0: 低リスク - VFR判定ロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] mkvDemuxer.Runのタイムスタンプ処理を確認
- [ ] CommandLineDemuxer.Runのタイムスタンプ処理を確認
- [ ] ExtractTimestamps/TimestampsModeの定義を確認
- [ ] VFR判定条件を確認
