---
generated_at: 2026-01-21 17:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：11-添付ファイル抽出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（1秒以内）**：具体的なベンチマーク根拠なし
  2. **セキュリティ考慮事項**：コード上の実装確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - mkvDemuxerクラスの実装
- E-02: `Source/Forms/StreamDemuxForm.vb` - UIフォームの実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連定義
- E-05: `Source/General/MediaInfo.vb` - メディア情報解析

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MKVファイルから添付ファイルを抽出する機能 | E-01, E-03 | ○ |
| C-02 | StreamDemuxFormでlvAttachmentsを使用 | E-02, E-04 | ○ |
| C-03 | mkvextractコマンドを使用 | E-01 | ○ |
| C-04 | MKVToolNixが必要 | E-01 | ○ |
| C-05 | 入力パラメータ（SourcePath）の存在 | E-02 | ○ |
| C-06 | MediaInfoで添付ファイル情報取得 | E-05 | ○ |
| C-07 | Procクラスで外部プロセス実行 | E-01 | ○ |
| C-08 | WebMファイルも対応 | E-01 | ○ |
| C-09 | フォントファイル（ttf, otf）の抽出 | E-01 | ○ |
| C-10 | チェックボックスで選択 | E-02 | ○ |
| C-11 | 一時ディレクトリへの出力 | E-01 | ○ |
| C-12 | エラー時のメッセージ表示 | E-01 | ○ |
| C-13 | トランザクション管理なし | E-01 | ○ |
| C-14 | ListView表示が1秒以内 | **根拠なし** | △ |
| C-15 | セキュリティ考慮（ウイルススキャン対象外） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値（1秒以内）は設計上の推奨値であり、実測データやベンチマーク結果が存在しない
  - 候補：パフォーマンステスト実施 / 要件定義書の確認 / 開発者へのヒアリング
- セキュリティ考慮事項はベストプラクティスとして記載したが、コード上での実装確認がない
  - 候補：セキュリティレビュー実施 / ウイルス対策ソフトとの連携確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み
- 1: 中リスク - パフォーマンス要件は実測が必要
- 0: 低リスク - セキュリティは一般的なガイドラインとして記載

## 6) レビュアーチェックリスト（最小）
- [ ] mkvDemuxer.Demux()の実装がドキュメントと一致しているか確認
- [ ] StreamDemuxFormのlvAttachmentsの動作確認
- [ ] パフォーマンス要件（1秒以内）の妥当性検証
- [ ] セキュリティ考慮事項の必要性と実装可否の検討
