---
generated_at: 2026-01-21 17:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：12-x265エンコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **圧縮効率50%向上の主張**：一般的な知識だがコード上の根拠なし
  2. **x265が最も普及しているHEVCエンコーダー**：外部情報に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Encoding/x265Enc.vb` - x265Encクラスの実装（112-500行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連定義
- E-04: `Source/General/MediaInfo.vb` - メディア情報解析
- E-05: `Source/General/Proc.vb` - プロセス実行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | x265エンコーダーでHEVC形式にエンコード | E-01, E-02 | ○ |
| C-02 | CRF/2パス/3パスモードをサポート | E-01 (115-121行目) | ○ |
| C-03 | 3パスは1→3→2の順序で実行 | E-01 (118-120行目) | ○ |
| C-04 | チャンクエンコードのサポート | E-01 (322-368行目) | ○ |
| C-05 | Dolby Vision使用時はチャンク不可 | E-01 (323行目) | ○ |
| C-06 | HDR10/HDR10+メタデータの自動インポート | E-01 (175-311行目) | ○ |
| C-07 | Dolby Vision RPUファイルの前処理 | E-01 (148-173行目) | ○ |
| C-08 | 出力ファイル形式は.hevc | E-01 (106-110行目) | ○ |
| C-09 | Procクラスでプロセス実行 | E-01 (129-145行目), E-05 | ○ |
| C-10 | AviSynth/VapourSynthスクリプト入力 | E-01 (126-127行目) | ○ |
| C-11 | プリセットのサポート | E-01 (17-18行目) | ○ |
| C-12 | コマンドラインパラメータのGUI設定 | E-01 (441-477行目) | ○ |
| C-13 | MainFormからエンコード実行 | E-03 | ○ |
| C-14 | 圧縮品質チェック機能 | E-01 (370-428行目) | ○ |
| C-15 | ビットレート設定 | E-01 (313-320行目) | ○ |
| C-16 | QualityModeプロパティ | E-01 (479-486行目) | ○ |
| C-17 | デフォルトMuxerはMkvMuxer | E-01 (494-496行目) | ○ |
| C-18 | MediaInfoでメタデータ取得 | E-01 (179行目), E-04 | ○ |
| C-19 | H.264比で50%のファイルサイズ削減 | **一般知識** | △ |
| C-20 | x265が最も普及しているHEVCエンコーダー | **外部情報** | △ |

## 4) 不足情報（Unknown / Missing）
- 「H.264比で50%のファイルサイズ削減」は一般的に知られている情報だが、StaxRipコード内に根拠がない
  - 候補：x265公式ドキュメントの参照 / ベンチマーク結果の追加
- 「x265が最も普及しているHEVCエンコーダー」は市場調査に基づく主張
  - 候補：外部ソースへの参照追加

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み
- 0: 低リスク - 3パス順序（1→3→2）はコード内のコメントでも確認
- 1: 中リスク - 性能に関する主張は実測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Encode()メソッドの2パス/3パス分岐ロジックが正しいか確認
- [ ] SetMetaData()のHDRメタデータ処理が正確か確認
- [ ] BeforeEncoding()のDolby Vision処理が正確か確認
- [ ] 圧縮効率に関する記述を外部ソースで裏付け
