---
generated_at: 2026-01-21 17:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：13-x264エンコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **映画スタジオやストリーミングサービスでの使用**：外部情報に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Encoding/x264Enc.vb` - x264Encクラスの実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | x264でH.264/AVC形式にエンコード | E-01, E-02 | ○ |
| C-02 | CRF/2パスモードをサポート | E-01 | ○ |
| C-03 | プリセット・チューニングオプション | E-01 | ○ |
| C-04 | baseline/main/highプロファイル | E-01 | ○ |
| C-05 | AviSynth/VapourSynthスクリプト入力 | E-01 | ○ |
| C-06 | Procクラスでプロセス実行 | E-01 | ○ |
| C-07 | MainFormからエンコード実行 | E-03 | ○ |
| C-08 | チャンクエンコード対応 | E-01 | ○ |
| C-09 | 8bit/10bitエンコード | E-01 | ○ |
| C-10 | 出力形式.264 | E-01 | ○ |
| C-11 | コマンドラインパラメータGUI | E-03 | ○ |
| C-12 | 映画スタジオでの使用実績 | **外部情報** | △ |

## 4) 不足情報（Unknown / Missing）
- 「映画スタジオやストリーミングサービスでの使用」は外部情報に依存
  - 候補：x264公式サイトへの参照追加

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Encode()メソッドの実装確認
- [ ] プロファイル・レベル設定の確認
- [ ] 2パスエンコードのロジック確認
