---
generated_at: 2026-01-21 17:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：14-NVEncエンコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **品質がソフトウェアエンコードに劣る場合がある**：定性的記述で根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Encoding/NVEnc.vb` - NVEncクラスの実装（1-400行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NVIDIAハードウェアエンコーダーを使用 | E-01, E-02 | ○ |
| C-02 | H.264/HEVC/AV1対応 | E-01 (157-163行目) | ○ |
| C-03 | NVEncCツールを使用 | E-01 (21-25行目) | ○ |
| C-04 | --check-hwでハードウェアチェック | E-01 (130行目) | ○ |
| C-05 | HEVCサポート確認 | E-01 (175-181行目) | ○ |
| C-06 | HDRメタデータ自動インポート | E-01 (230-366行目) | ○ |
| C-07 | Dolby Vision RPU処理 | E-01 (195-228行目) | ○ |
| C-08 | cmd.exe経由で実行 | E-01 (189-190行目) | ○ |
| C-09 | AV1はMuxer出力拡張子使用 | E-01 (157-158行目) | ○ |
| C-10 | Dolby Visionモード設定 | E-01 (207-212行目) | ○ |
| C-11 | luminance値の変換 | E-01 (241-242, 301-302行目) | ○ |
| C-12 | MasteringDisplay処理 | E-01 (289-334行目) | ○ |
| C-13 | MainFormから設定 | E-03 | ○ |
| C-14 | 進捗表示 | E-01 (188行目) | ○ |
| C-15 | ソフトウェアより品質が劣る場合あり | **一般知識** | △ |

## 4) 不足情報（Unknown / Missing）
- 「品質がソフトウェアエンコードに劣る場合がある」は一般的な知識だがコード上の根拠なし
  - 候補：品質比較テスト結果の追加 / 外部ベンチマーク参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み
- 1: 中リスク - ハードウェア依存の動作は実機テストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] Encode()メソッドのHEVCサポートチェックロジック確認
- [ ] SetMetaData()のHDRメタデータ処理確認
- [ ] BeforeEncoding()のDolby Vision処理確認
- [ ] 実機でのハードウェアチェック動作確認
