---
generated_at: 2026-01-21 17:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-QSVEncエンコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Encoding/QSVEnc.vb` - QSVEncクラスの実装（1-400行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Intel QSVハードウェアエンコーダー使用 | E-01, E-02 | ○ |
| C-02 | H.264/HEVC/MPEG-2/VP9/AV1対応 | E-01 (165-177行目) | ○ |
| C-03 | QSVEncCツールを使用 | E-01 (22-26行目) | ○ |
| C-04 | --check-featuresでサポート確認 | E-01 (181行目) | ○ |
| C-05 | HEVCサポートチェック | E-01 (180-186行目) | ○ |
| C-06 | HDRメタデータ処理 | E-01 (236-372行目) | ○ |
| C-07 | Dolby Vision RPU処理 | E-01 (201-234行目) | ○ |
| C-08 | cmd.exe経由で実行 | E-01 (195-196行目) | ○ |
| C-09 | 出力拡張子がコーデック依存 | E-01 (165-177行目) | ○ |
| C-10 | QualityModeの判定ロジック | E-01 (381-387行目) | ○ |
| C-11 | MainFormから設定 | E-03 | ○ |
| C-12 | SkipStringの設定 | E-01 (194行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み
- 1: 中リスク - ハードウェア依存の動作は実機テストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] Encode()メソッドのHEVCサポートチェックロジック確認
- [ ] SetMetaData()のHDRメタデータ処理確認
- [ ] BeforeEncoding()のDolby Vision処理確認
- [ ] 実機でのハードウェアチェック動作確認
