---
generated_at: 2026-01-21 18:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：17-AV1エンコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **HEVCと同等以上の圧縮効率**：一般知識だがコード上の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Encoding/AOMEnc.vb` - AOMEncクラスの実装
- E-02: `Source/Encoding/SvtAv1Enc.vb` - SvtAv1Encクラスの実装
- E-03: `Source/Encoding/Rav1e.vb` - Rav1eクラスの実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AV1コーデックでエンコード | E-01, E-02, E-03, E-04 | ○ |
| C-02 | AOMEnc/SVT-AV1/Rav1eの3種対応 | E-01, E-02, E-03 | ○ |
| C-03 | 2パスエンコード対応 | E-01 (83-90行目) | ○ |
| C-04 | チャンクエンコード対応 | E-01 (110-149行目) | ○ |
| C-05 | IVF/OBU/WebM出力形式 | E-01 (75-81行目) | ○ |
| C-06 | CQ/Qレートモード | E-01 (299-306行目) | ○ |
| C-07 | 統計ファイル(.fpf)生成 | E-01 (796-797行目) | ○ |
| C-08 | VUIメタデータインポート(SVT-AV1) | E-02 (145-238行目) | ○ |
| C-09 | avs2pipemod/vspipeでパイプ入力 | E-01 (648-668行目) | ○ |
| C-10 | チャンク分割計算 | E-01 (118-136行目) | ○ |
| C-11 | MainFormから設定 | E-05 | ○ |
| C-12 | Passes.Value = 1で2パス | E-01 (87-89行目) | ○ |
| C-13 | CanChunkEncode()の実装 | E-01 (110-112行目) | ○ |
| C-14 | GetChunks()の実装 | E-01 (114-116行目) | ○ |
| C-15 | HEVCと同等以上の圧縮効率 | **一般知識** | △ |

## 4) 不足情報（Unknown / Missing）
- 「HEVCと同等以上の圧縮効率」は一般的な知識だがコード上の根拠なし
  - 候補：AV1公式ドキュメントへの参照追加

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み
- 0: 低リスク - 3種のエンコーダー実装を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AOMEnc.Encode()の2パス処理確認
- [ ] GetChunkEncodeActions()のチャンク分割ロジック確認
- [ ] SVT-AV1のVUIメタデータ処理確認
- [ ] Rav1eの2パス処理確認
