---
generated_at: 2026-01-21 18:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-チャンクエンコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Encoding/x265Enc.vb` - x265Encのチャンクエンコード実装（322-368行目）
- E-02: `Source/Encoding/AOMEnc.vb` - AOMEncのチャンクエンコード実装（110-149行目）
- E-03: `Source/Encoding/SvtAv1Enc.vb` - SvtAv1Encのチャンクエンコード実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ビデオをチャンクに分割して並列エンコード | E-01, E-02, E-04 | ○ |
| C-02 | CanChunkEncode()で可否判定 | E-01 (322-324行目) | ○ |
| C-03 | GetChunks()でチャンク数取得 | E-01 (326-328行目) | ○ |
| C-04 | GetChunkEncodeActions()でActionリスト生成 | E-01 (330-368行目) | ○ |
| C-05 | Dolby Vision時はチャンク不可 | E-01 (323行目) | ○ |
| C-06 | 均等分割計算ロジック | E-01 (336行目) | ○ |
| C-07 | 端数フレームは最後のチャンクに含める | E-01 (341行目) | ○ |
| C-08 | チャンク名に_chunk接尾辞 | E-01 (346-347行目) | ○ |
| C-09 | 2パスモード時は各チャンクで2パス実行 | E-01 (350-354行目) | ○ |
| C-10 | AOMEncのチャンクエンコード | E-02 (110-149行目) | ○ |
| C-11 | SVT-AV1のチャンクエンコード | E-03 | ○ |
| C-12 | Chunks > 1でチャンクエンコード有効 | E-01 (323行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CanChunkEncode()のDolby Vision制限確認
- [ ] GetChunkEncodeActions()のチャンク範囲計算確認
- [ ] 2パスモード時の処理順序確認
- [ ] チャンク結合（Muxer）の動作確認
