---
generated_at: 2026-01-21 18:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-2パスエンコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Encoding/x265Enc.vb` - x265Encの2パス/3パス実装（112-122行目）
- E-02: `Source/Encoding/x264Enc.vb` - x264Encの2パス実装
- E-03: `Source/Encoding/AOMEnc.vb` - AOMEncの2パス実装（83-90行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 2パスVBRエンコード | E-01, E-04 | ○ |
| C-02 | 1パス目で統計情報収集 | E-01 (112-114行目) | ○ |
| C-03 | 2パス目で最適ビットレート配分 | E-01 (115-116行目) | ○ |
| C-04 | x265の3パスは1→3→2順序 | E-01 (117-121行目) | ○ |
| C-05 | 統計ファイル生成（.log, .cutree） | E-01 | ○ |
| C-06 | x264の2パス対応 | E-02 | ○ |
| C-07 | AOMEncの2パス対応 | E-03 (83-90行目) | ○ |
| C-08 | Mode = TwoPass/ThreePass | E-01 | ○ |
| C-09 | ビットレート指定が必須 | E-01 | ○ |
| C-10 | GetArgs()でpass引数生成 | E-01 (430-438行目) | ○ |
| C-11 | 3パスモードのコメント記載 | E-01 (118行目) | ○ |
| C-12 | AOMEncのPasses設定 | E-03 (279-285行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] x265Enc.Encode()の2パス/3パス処理順序確認
- [ ] 統計ファイルパスの生成ロジック確認
- [ ] x264, AOMEncの2パス実装確認
