---
generated_at: 2026-01-21 18:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-オーディオDemux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Audio.vb` - Audioクラスの実装（8-300行目）
- E-02: `Source/General/Demux.vb` - 各種Demuxer実装
- E-03: `Source/Forms/StreamDemuxForm.vb` - Demux選択UI
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | オーディオストリームの分離（Demux） | E-01, E-04 | ○ |
| C-02 | MKV/MP4/M2TS等からの抽出 | E-01 (49-60行目) | ○ |
| C-03 | mkvextract/ffmpeg/MP4Box/eac3to使用 | E-01, E-02 | ○ |
| C-04 | Audio.Process()がエントリーポイント | E-01 (8-69行目) | ○ |
| C-05 | コンテナ形式に応じたDemuxer選択 | E-01 (49-60行目) | ○ |
| C-06 | 出力ファイル名にID、言語、遅延含む | E-01 (71-99行目) | ○ |
| C-07 | Audio.Cut()でカット処理 | E-01 (247-272行目) | ○ |
| C-08 | カットモード分岐（mkvmerge/NicAudio/DirectShow） | E-01 (256-271行目) | ○ |
| C-09 | StreamDemuxFormでストリーム選択 | E-03, E-05 | ○ |
| C-10 | MediaInfoでストリーム情報取得 | E-01 (17-18行目) | ○ |
| C-11 | MKV/WebMはmkvDemuxer使用 | E-01 (50-51行目) | ○ |
| C-12 | MP4はMP4BoxDemuxer使用 | E-01 (52-53行目) | ○ |
| C-13 | その他はffmpegDemuxer使用 | E-01 (57-58行目) | ○ |
| C-14 | p.TempDirへ出力 | E-01 | ○ |
| C-15 | 遅延情報の保持 | E-01 (85-88行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Audio.Process()のDemuxer選択ロジック確認
- [ ] GetBaseNameForStream()の命名規則確認
- [ ] Audio.Cut()の各カットモード実装確認
- [ ] 各Demuxer（mkvDemuxer, ffmpegDemuxer, MP4BoxDemuxer）の動作確認
