---
generated_at: 2026-01-21 17:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：21-オーディオエンコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/AudioProfile.vb` - GUIAudioProfile.Encode()メソッド（900-961行目）
- E-02: `Source/General/AudioProfile.vb` - GetCommandLine()メソッド（1083-1098行目）
- E-03: `Source/General/AudioProfile.vb` - GetQaacCommandLine()（1355-1428行目）
- E-04: `Source/General/AudioProfile.vb` - GetffmpegCommandLine()（1467-1668行目）
- E-05: `Source/General/AudioProfile.vb` - GetOpusencCommandLine()（1280-1352行目）
- E-06: `Source/General/AudioProfile.vb` - NormalizeFF()（963-1011行目）
- E-07: `Source/General/AudioProfile.vb` - Parameters内部クラス（1778-1934行目）
- E-08: `Source/General/AudioProfile.vb` - AudioCodec Enum（1937-1949行目）
- E-09: `Source/General/AudioProfile.vb` - GuiAudioEncoder Enum（2067-2075行目）
- E-10: `Source/General/AudioProfile.vb` - GetEncoder()（1046-1081行目）
- E-11: `Source/General/AudioProfile.vb` - GetBitrate()（855-898行目）
- E-12: `Source/General/Audio.vb` - GetLoudNormArgs()（448-458行目）
- E-13: `Source/General/Audio.vb` - GetDynAudNormArgs()（460-474行目）
- E-14: `Source/Forms/AudioForm.vb` - オーディオ設定UI
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.6 AudioForm

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | オーディオエンコードはGUIAudioProfile.Encode()がエントリーポイント | E-01 | ○ |
| C-02 | 対応コーデックはAAC、AC3、EAC3、FLAC、MP3、Opus、Vorbis、W64、WAV | E-08 | ○ |
| C-03 | 対応エンコーダーはAutomatic、qaac、fdkaac、opusenc、eac3to、ffmpeg、deezy | E-09 | ○ |
| C-04 | GetEncoder()でコーデックに応じたエンコーダーを自動選択 | E-10 | ○ |
| C-05 | Automaticの場合、AAC=qaac、Opus=opusencを選択 | E-10 | ○ |
| C-06 | GetCommandLine()で各エンコーダー固有のコマンドラインを生成 | E-02 | ○ |
| C-07 | qaac用コマンドラインはGetQaacCommandLine()で生成 | E-03 | ○ |
| C-08 | ffmpeg用コマンドラインはGetffmpegCommandLine()で生成 | E-04 | ○ |
| C-09 | opusenc用コマンドラインはGetOpusencCommandLine()で生成 | E-05 | ○ |
| C-10 | NormalizeFF()でffmpegによる音量正規化を実行 | E-06 | ○ |
| C-11 | 正規化モードはvolumedetect、loudnorm、dynaudnormの3種類 | E-07 | ○ |
| C-12 | loudnormパラメータはGetLoudNormArgs()で生成 | E-12 | ○ |
| C-13 | dynaudnormパラメータはGetDynAudNormArgs()で生成 | E-13 | ○ |
| C-14 | VBRモード時はGetBitrate()でビットレートを推定 | E-11 | ○ |
| C-15 | Parameters内部クラスにエンコード設定パラメータを保持 | E-07 | ○ |
| C-16 | AudioFormでオーディオ設定UIを提供 | E-14, E-15 | ○ |
| C-17 | 出力ファイルは一時ディレクトリ（p.TempDir）に生成 | E-01 | ○ |
| C-18 | Procオブジェクトで外部エンコーダーを起動 | E-01 | ○ |
| C-19 | 出力ファイル未検出時はErrorAbortExceptionをスロー | E-01 | ○ |
| C-20 | ChannelsModeでチャンネル数を制御（Original、1、2、6、7、8） | E-07 | ○ |
| C-21 | SamplingRateでサンプリングレートを制御 | E-07 | ○ |
| C-22 | CustomSwitchesでカスタムコマンドラインスイッチを追加可能 | E-07 | ○ |
| C-23 | HandlesDelay()で一部エンコーダーはディレイ値を直接処理 | E-01 | ○ |
| C-24 | Apple Application Supportはqaac使用時に必要 | E-01 | ○ |
| C-25 | 処理時間は入力ファイル再生時間と同程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は、ソースコードに明示的な記載がないため推定値
  - 候補：実機計測 / ベンチマークテスト / 開発者ヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はすべてソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は実測値に基づく検証が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] GetEncoder()のエンコーダー選択ロジックが正しいか確認
- [ ] 各GetXxxCommandLine()メソッドのパラメータ設定が正しいか確認
- [ ] NormalizeFF()の正規化処理が期待通りか確認
- [ ] エラー処理（出力ファイル未検出時）の動作確認
