---
generated_at: 2026-01-21 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-オーディオ正規化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/AudioProfile.vb` - NormalizeFF()（963-1011行目）
- E-02: `Source/General/AudioProfile.vb` - Parameters.ffmpegNormalizeMode（1836行目）
- E-03: `Source/General/AudioProfile.vb` - Parameters.ffmpegLoudnorm*（1840-1846行目）
- E-04: `Source/General/AudioProfile.vb` - Parameters.ffmpegDynaudnorm*（1848-1856行目）
- E-05: `Source/General/Audio.vb` - GetLoudNormArgs()（448-458行目）
- E-06: `Source/General/Audio.vb` - GetDynAudNormArgs()（460-474行目）
- E-07: `Source/General/AudioProfile.vb` - GetffmpegCommandLine()（1624-1630行目）
- E-08: `Source/Forms/AudioForm.vb` - cbNormalize チェックボックス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NormalizeFF()が正規化処理のエントリーポイント | E-01 | ○ |
| C-02 | 3つの正規化モード（volumedetect、loudnorm、dynaudnorm）をサポート | E-02 | ○ |
| C-03 | loudnormのデフォルト値: Integrated=-24、TruePeak=-2、LRA=7 | E-03 | ○ |
| C-04 | dynaudnormのデフォルト値: F=500、G=31、P=0.95、M=10 | E-04 | ○ |
| C-05 | GetLoudNormArgs()でloudnormフィルタパラメータを生成 | E-05 | ○ |
| C-06 | GetDynAudNormArgs()でdynaudnormフィルタパラメータを生成 | E-06 | ○ |
| C-07 | volumedetectはmax_volumeを検出しGain値を設定 | E-01 | ○ |
| C-08 | loudnormはInput Integrated/TruePeak/LRA/Thresholdを測定 | E-01 | ○ |
| C-09 | 測定値はRegex.Matchでログから抽出 | E-01 | ○ |
| C-10 | DeeZyエンコーダー使用時は正規化スキップ | E-01 | ○ |
| C-11 | ExtractCore時は正規化スキップ | E-01 | ○ |
| C-12 | エンコード時にGetffmpegCommandLine()で正規化フィルタ適用 | E-07 | ○ |
| C-13 | AudioFormのcbNormalizeで正規化を有効/無効設定 | E-08 | ○ |
| C-14 | ffmpegの-af volumedetectで分析パス実行 | E-01 | ○ |
| C-15 | ffmpegの-af loudnormで分析パス実行 | E-01 | ○ |
| C-16 | 分析結果は-f null NULで破棄 | E-01 | ○ |
| C-17 | measured_*パラメータで2パス目に測定値を渡す | E-05 | ○ |
| C-18 | dynaudnormは1パス処理で動的正規化 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NormalizeFF()の条件分岐が正しいか確認
- [ ] loudnormパラメータの順序が正しいか確認
- [ ] dynaudnormのデフォルト値がffmpeg仕様と一致するか確認
- [ ] max_volume検出の正規表現パターンが正しいか確認
