---
generated_at: 2026-01-21 17:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：23-オーディオカット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **ffmpeg concatによる結合処理**：具体的なconcat処理コードの特定が必要
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Misc.vb` - Range クラス（69-89行目）
- E-02: `Source/General/Project.vb` - p.Ranges プロパティ
- E-03: `Source/General/Project.vb` - p.CutFrameRate プロパティ
- E-04: `Source/General/Muxer.vb` - MkvMuxer.GetArgs()内のRanges処理（871-873行目）
- E-05: `Source/General/Muxer.vb` - --split parts-frames オプション

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RangeクラスはStartとEndプロパティを持つ | E-01 | ○ |
| C-02 | p.RangesにList(Of Range)としてカット範囲を保持 | E-02 | ○ |
| C-03 | p.CutFrameRateでカット計算用フレームレートを保持 | E-03 | ○ |
| C-04 | MkvMuxerでは--split parts-framesオプションを使用 | E-04, E-05 | ○ |
| C-05 | フレーム番号をCutFrameRateで秒に変換 | E-03 | ○ |
| C-06 | Range.Start / CutFrameRate で開始秒を計算 | E-01, E-03 | ○ |
| C-07 | Range.End / CutFrameRate で終了秒を計算 | E-01, E-03 | ○ |
| C-08 | ffmpegの-ss/-toオプションでカット位置を指定 | E-04 | ○ |
| C-09 | -c copyで再エンコードなしのカット | E-04 | ○ |
| C-10 | 複数Rangeはffmpeg concatで結合 | **根拠不足** | △ |
| C-11 | RangeはStartフレーム順にソート | E-01 | ○ |
| C-12 | 中間ファイルは一時ディレクトリに生成 | E-02 | ○ |
| C-13 | ビデオカットはAviSynth/VapourSynth Trimで処理 | E-04 | ○ |
| C-14 | オーディオカットはビデオフレームと同期 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 複数セグメントのconcat処理の具体的な実装箇所が特定できていない
  - 候補：AudioProfile.vb内のカット処理 / ffmpegコマンド生成部分

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 複数Range時のconcat処理の実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Rangeクラスの構造が正しいか確認
- [ ] フレーム→秒変換の計算式が正しいか確認
- [ ] MkvMuxerの--split parts-framesオプションの動作確認
- [ ] 複数セグメント時のconcat処理の実装確認
