---
generated_at: 2026-01-21 17:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：24-チャンネルダウンミックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **panフィルタの係数**：具体的なフィルタ係数の検証が必要
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/AudioProfile.vb` - ChannelsMode Enum（2020-2027行目）
- E-02: `Source/General/AudioProfile.vb` - Parameters.Channels プロパティ（1813行目）
- E-03: `Source/General/AudioProfile.vb` - Parameters.CenterOptimizedStereo（1886行目）
- E-04: `Source/General/AudioProfile.vb` - GetffmpegCommandLine() チャンネル処理
- E-05: `Source/Forms/AudioForm.vb` - mbChannels メニューボタン
- E-06: `Source/Forms/AudioForm.vb` - cbCenterOptimizedStereo チェックボックス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ChannelsModeはOriginal、_1、_2、_6、_7、_8の値を持つ | E-01 | ○ |
| C-02 | Parameters.Channelsでチャンネル数を保持 | E-02 | ○ |
| C-03 | Parameters.CenterOptimizedStereoでセンター最適化を制御 | E-03 | ○ |
| C-04 | ChannelsMode=Originalの場合はダウンミックスしない | E-01, E-04 | ○ |
| C-05 | ffmpegの-acオプションでチャンネル数を指定 | E-04 | ○ |
| C-06 | CenterOptimizedStereo有効時はpanフィルタを使用 | E-04 | ○ |
| C-07 | panフィルタでFC（センター）を両チャンネルに分配 | **根拠不足** | △ |
| C-08 | 入力ch < 出力chの場合はダウンミックスしない | E-04 | ○ |
| C-09 | AudioFormでmbChannelsによりチャンネル数を選択 | E-05 | ○ |
| C-10 | AudioFormでcbCenterOptimizedStereoにより最適化を設定 | E-06 | ○ |
| C-11 | ChannelsModeの_1, _2等はIntegerキャストでチャンネル数 | E-01 | ○ |
| C-12 | eac3toでDTS Core抽出時はオリジナルch維持 | E-04 | ○ |
| C-13 | ダウンミックスはエンコード処理と統合 | E-04 | ○ |
| C-14 | LFEはダウンミックス時に減衰 | E-04 | ○ |
| C-15 | サラウンドチャンネル（BL/BR）も適切にミックス | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- panフィルタの具体的な係数値（0.5*FC、0.707*FL等）の実装確認
  - 候補：GetffmpegCommandLine()内のpanフィルタ文字列

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - panフィルタ係数が標準的なダウンミックス係数と一致するか確認

## 6) レビュアーチェックリスト（最小）
- [ ] ChannelsModeのEnum値が正しいか確認
- [ ] CenterOptimizedStereo適用時のpanフィルタ構文確認
- [ ] -acオプションの適用条件確認
- [ ] DTS Core抽出時の挙動確認
