---
generated_at: 2026-01-21 17:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：25-字幕抽出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **ffmpegによる字幕抽出コマンド**：具体的なコマンドライン確認
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Misc.vb` - Subtitle クラス（1482-1682行目）
- E-02: `Source/General/Misc.vb` - Subtitle.Ext プロパティ（1526-1566行目）
- E-03: `Source/General/Misc.vb` - Subtitle.Create() 静的メソッド（1576-1682行目）
- E-04: `Source/General/Muxer.vb` - Muxer.Init()内の字幕自動検出（178-221行目）
- E-05: `Source/General/Muxer.vb` - Muxer.Subtitles プロパティ（84-97行目）
- E-06: `Source/General/MediaInfo.vb` - GetSubtitles()メソッド
- E-07: `Source/Forms/StreamDemuxForm.vb` - 字幕選択UI

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SubtitleクラスはPath、Language、CodecString等を保持 | E-01 | ○ |
| C-02 | Subtitle.ExtでCodecStringから適切な拡張子を返す | E-02 | ○ |
| C-03 | VobSubはidx、PGSはsup、ASSはass等を返す | E-02 | ○ |
| C-04 | Subtitle.Create()でファイルパスからSubtitleオブジェクト生成 | E-03 | ○ |
| C-05 | idxファイルの場合は内部をパースして言語情報取得 | E-03 | ○ |
| C-06 | MKV/MP4/M2TSの場合はMediaInfo.GetSubtitles()使用 | E-03 | ○ |
| C-07 | Muxer.Init()で一時ディレクトリの字幕を自動検出 | E-04 | ○ |
| C-08 | FileTypes.SubtitleExludingContainersで字幕ファイル判定 | E-04 | ○ |
| C-09 | ファイル名に"forced"含む場合はForcedフラグ設定 | E-03 | ○ |
| C-10 | ファイル名に"commentary"含む場合はCommentaryフラグ設定 | E-03 | ○ |
| C-11 | ファイル名に"hearingimpaired"含む場合はHearingimpairedフラグ設定 | E-03 | ○ |
| C-12 | Muxer.Subtitles はList(Of Subtitle)型 | E-05 | ○ |
| C-13 | MediaInfo.GetSubtitles()で字幕ストリーム一覧取得 | E-06 | ○ |
| C-14 | StreamDemuxFormで字幕ストリーム選択UI提供 | E-07 | ○ |
| C-15 | PreferredSubtitlesで言語フィルタリング | E-03, E-04 | ○ |
| C-16 | SubtitleMode=Allの場合は全字幕抽出 | E-03, E-04 | ○ |
| C-17 | SubtitleMode=Disabledの場合は字幕処理スキップ | E-03, E-04 | ○ |
| C-18 | DefaultSubtitleModeで既定字幕を設定 | E-03 | ○ |
| C-19 | mkvextractでMKVから字幕抽出 | E-04 | ○ |
| C-20 | ffmpegで汎用字幕抽出 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ffmpegによる字幕抽出の具体的なコマンドライン実装
  - 候補：Demux.vb内のffmpeg字幕抽出コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Subtitle.Ext()の形式判定が完全か確認
- [ ] Subtitle.Create()の各ブランチの動作確認
- [ ] Muxer.Init()の字幕自動検出ロジック確認
- [ ] PreferredSubtitlesフィルタの動作確認
