---
generated_at: 2026-01-21 17:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-字幕追加

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Muxer.vb` - Muxer.Subtitles プロパティ（84-97行目）
- E-02: `Source/General/Muxer.vb` - ExpandMacros()（131-147行目）
- E-03: `Source/General/Muxer.vb` - MkvMuxer.GetArgs() 字幕処理（789-819行目）
- E-04: `Source/General/Muxer.vb` - MP4Muxer.GetArgs() 字幕処理（380-392行目）
- E-05: `Source/General/Misc.vb` - Subtitle クラス（1482-1518行目）
- E-06: `Source/Forms/MuxerForm.vb` - 字幕設定UI

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Muxer.SubtitlesはList(Of Subtitle)型 | E-01 | ○ |
| C-02 | Enabled=Falseの字幕はMuxしない | E-03, E-04 | ○ |
| C-03 | ExpandMacros()でTitleのマクロを展開 | E-02 | ○ |
| C-04 | %language_native%でLanguage.CultureInfo.NativeNameに展開 | E-02 | ○ |
| C-05 | %language_english%でLanguage.EnglishNameに展開 | E-02 | ○ |
| C-06 | MkvMuxerで--languageオプション設定 | E-03 | ○ |
| C-07 | MkvMuxerで--default-track-flagオプション設定 | E-03 | ○ |
| C-08 | MkvMuxerで--forced-display-flagオプション設定 | E-03 | ○ |
| C-09 | MkvMuxerで--commentary-flagオプション設定 | E-03 | ○ |
| C-10 | MkvMuxerで--hearing-impaired-flagオプション設定 | E-03 | ○ |
| C-11 | MkvMuxerで--track-nameオプション設定 | E-03 | ○ |
| C-12 | MP4Muxerでidxはインデックスでストリーム指定 | E-04 | ○ |
| C-13 | MP4Muxerで:lang=で言語指定 | E-04 | ○ |
| C-14 | MP4Muxerで:name=でタイトル指定 | E-04 | ○ |
| C-15 | MP4MuxerはSRT/VobSubのみ対応 | E-04 | ○ |
| C-16 | MuxerFormで字幕設定UIを提供 | E-06 | ○ |
| C-17 | Subtitle.Languageで言語を保持 | E-05 | ○ |
| C-18 | Subtitle.Forced/Default/Commentary等フラグ保持 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ExpandMacros()のマクロパターン網羅性確認
- [ ] MkvMuxer字幕オプションの順序と構文確認
- [ ] MP4Muxerの字幕形式制限の動作確認
- [ ] MuxerFormの字幕編集UI動作確認
