---
generated_at: 2026-01-21 18:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：27-ハードコード字幕

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **VapourSynthフィルタ構文**：具体的な実装確認が必要
  2. **フィルタ位置（リサイズ後）**：スクリプト生成ロジックの確認
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Project.vb` - p.ConvertSup2Sub プロパティ
- E-02: `Source/General/Muxer.vb` - 194行目 ConvertSup2Sub判定
- E-03: `Source/General/GlobalClass.vb` - 字幕関連ユーティリティ
- E-04: `Source/General/VideoFilter.vb` - フィルタ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ハードコード字幕はビデオフレームに字幕を焼き付ける | E-04 | ○ |
| C-02 | AviSynthでTextSubフィルタを使用 | E-04 | ○ |
| C-03 | AviSynthでVobSubフィルタを使用 | E-04 | ○ |
| C-04 | SRT/ASS形式はTextSubで処理 | E-04 | ○ |
| C-05 | VobSub(idx+sub)形式はVobSubフィルタで処理 | E-04 | ○ |
| C-06 | PGS(sup)はConvertSup2Sub有効時に変換後適用 | E-01, E-02 | ○ |
| C-07 | AviSynthではバックスラッシュをエスケープ | E-04 | ○ |
| C-08 | VapourSynthでcore.sub.TextFileを使用 | **根拠不足** | △ |
| C-09 | 字幕フィルタはリサイズ後に適用 | **根拠不足** | △ |
| C-10 | フィルタエラーはスクリプトエラーとして表示 | E-04 | ○ |
| C-11 | TextSub構文: TextSub("path") | E-04 | ○ |
| C-12 | VobSub構文: VobSub("path") | E-04 | ○ |
| C-13 | MainFormでフィルタ設定UIを提供 | E-04 | ○ |
| C-14 | PreviewFormで字幕焼き付けのプレビュー可能 | E-04 | ○ |
| C-15 | VideoFilterクラスでフィルタを定義 | E-04 | ○ |
| C-16 | エンコード時にフィルタが適用される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- VapourSynthの字幕フィルタ実装詳細
  - 候補：Script.vb内のVapourSynth字幕フィルタ生成コード
- フィルタ適用順序（リサイズとの関係）
  - 候補：Script.vb内のフィルタ順序制御ロジック

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - VapourSynth対応の実装確認が必要
- 1: 中リスク - フィルタ適用順序の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TextSub/VobSubフィルタの構文確認
- [ ] VapourSynth字幕フィルタの実装確認
- [ ] ConvertSup2Subの動作確認
- [ ] フィルタ適用順序（リサイズとの関係）確認
