---
generated_at: 2026-01-21 18:05:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-MKV Mux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Muxer.vb` - MkvMuxer クラス（624-986行目）
- E-02: `Source/General/Muxer.vb` - Muxer.Init()（157-276行目）
- E-03: `Source/General/Muxer.vb` - MkvMuxer.Init()（651-668行目）
- E-04: `Source/General/Muxer.vb` - MkvMuxer.GetArgs()（720-896行目）
- E-05: `Source/General/Muxer.vb` - MkvMuxer.Mux()（670-689行目）
- E-06: `Source/General/Muxer.vb` - MkvMuxer.WriteTagfile()（691-710行目）
- E-07: `Source/General/Muxer.vb` - AddAudioArgs()（899-966行目）
- E-08: `Source/General/Muxer.vb` - SupportedInputTypes（969-984行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MkvMuxerはMuxer基底クラスを継承 | E-01 | ○ |
| C-02 | OutputExt="mkv"を返す | E-01 | ○ |
| C-03 | mkvmergeを使用してMux | E-05 | ○ |
| C-04 | Init()でチャプター/字幕/添付を自動検出 | E-02 | ○ |
| C-05 | NFOファイルからタグを自動取得 | E-02 | ○ |
| C-06 | cover.jpg/png自動検出 | E-02, E-03 | ○ |
| C-07 | small_cover等の追加カバー検出 | E-03 | ○ |
| C-08 | attachment_プレフィックスで添付検出 | E-02 | ○ |
| C-09 | WriteTagfile()でXMLタグファイル生成 | E-06 | ○ |
| C-10 | GetArgs()でmkvmergeコマンドライン生成 | E-04 | ○ |
| C-11 | --languageでビデオ言語設定 | E-04 | ○ |
| C-12 | --track-nameでトラック名設定 | E-04 | ○ |
| C-13 | --aspect-ratioでDAR設定 | E-04 | ○ |
| C-14 | --default-durationでフレームレート設定 | E-04 | ○ |
| C-15 | --timestampsでタイムスタンプ設定 | E-04 | ○ |
| C-16 | 複数チャンク時は+で結合 | E-04 | ○ |
| C-17 | AddAudioArgs()でオーディオ設定 | E-07 | ○ |
| C-18 | --audio-tracksでトラック指定 | E-07 | ○ |
| C-19 | --aac-is-sbrでSBR指定 | E-07 | ○ |
| C-20 | --reduce-to-coreでDTS Core抽出 | E-07 | ○ |
| C-21 | --syncでディレイ設定 | E-07 | ○ |
| C-22 | --chaptersでチャプター追加 | E-04 | ○ |
| C-23 | --split parts-framesでカット | E-04 | ○ |
| C-24 | --engage append_and_split_flacを使用 | E-04 | ○ |
| C-25 | 終了コード0または1を許容 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GetArgs()のコマンドライン構造が正しいか確認
- [ ] AddAudioArgs()のオプション順序確認
- [ ] WriteTagfile()のXML形式確認
- [ ] Init()の自動検出ロジック確認
