---
generated_at: 2026-01-21 18:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-MP4 Mux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Muxer.vb` - MP4Muxer クラス（294-493行目）
- E-02: `Source/General/Muxer.vb` - MP4Muxer.GetArgs()（323-418行目）
- E-03: `Source/General/Muxer.vb` - MP4Muxer.AddAudio()（421-451行目）
- E-04: `Source/General/Muxer.vb` - MP4Muxer.Mux()（458-473行目）
- E-05: `Source/General/Muxer.vb` - SupportedInputTypes（479-491行目）
- E-06: `Source/General/Muxer.vb` - MP4Muxer.Init()（453-456行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MP4MuxerはMuxer基底クラスを継承 | E-01 | ○ |
| C-02 | OutputExt="mp4"を返す | E-01 | ○ |
| C-03 | MP4Boxを使用してMux | E-04 | ○ |
| C-04 | フレームレート0の場合-fpsで指定 | E-02 | ○ |
| C-05 | PAR="auto"または"0"の場合は自動計算 | E-02 | ○ |
| C-06 | -addでビデオ追加 | E-02 | ○ |
| C-07 | #video でビデオストリーム指定 | E-02 | ○ |
| C-08 | :par=x:y でPAR設定 | E-02 | ○ |
| C-09 | 複数チャンク時は-catで結合 | E-02 | ○ |
| C-10 | AddAudio()でオーディオ追加 | E-03 | ○ |
| C-11 | #trackID=idでストリーム指定 | E-03 | ○ |
| C-12 | ファイル名にSBR含む場合:sbr追加 | E-03 | ○ |
| C-13 | :lang=で言語指定 | E-03 | ○ |
| C-14 | :delay=でディレイ指定 | E-03 | ○ |
| C-15 | :tkhd=3:group=1でデフォルト指定 | E-03 | ○ |
| C-16 | 字幕はidx/srtのみ対応 | E-02, E-06 | ○ |
| C-17 | -chapでチャプター追加 | E-02 | ○ |
| C-18 | -itagsでiTunesタグ追加 | E-02 | ○ |
| C-19 | -newで出力ファイル指定 | E-02 | ○ |
| C-20 | 出力失敗時ErrorAbortExceptionスロー | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GetArgs()のコマンドライン構造が正しいか確認
- [ ] AddAudio()のオプション順序確認
- [ ] 字幕形式制限の動作確認
- [ ] PAR自動計算ロジック確認
