---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-Blu-ray/DVDサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Haaliスプリッター必要性の条件**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/eac3toForm.vb` - eac3toFormクラス定義（全体）
- E-02: `Source/Forms/eac3toForm.vb` - StartAnalyze（726-759行目）
- E-03: `Source/Forms/eac3toForm.vb` - Init（780-961行目）
- E-04: `Source/Forms/eac3toForm.vb` - GetArgs（967-1030行目）
- E-05: `Source/Forms/eac3toForm.vb` - AudioOutputFormats（586行目）
- E-06: `Source/General/Demux.vb` - Demuxerクラス定義
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.3定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Blu-ray/DVDサポート機能はeac3toFormダイアログを使用 | E-01, E-07 | ○ |
| C-02 | eac3toによるストリーム解析・抽出を行う | E-02 | ○ |
| C-03 | StartAnalyzeは726-759行目に定義 | E-02 | ○ |
| C-04 | Initは780-961行目に定義 | E-03 | ○ |
| C-05 | GetArgsは967-1030行目に定義 | E-04 | ○ |
| C-06 | AudioOutputFormatsにm4a/ac3/dts等が含まれる | E-05 | ○ |
| C-07 | 3Dコンテンツはエラーとなる | E-03 | ○ |
| C-08 | cbChaptersでチャプター抽出を制御 | E-01 | ○ |
| C-09 | cbVideoOutputでビデオ出力形式を選択 | E-01 | ○ |
| C-10 | lvAudioでオーディオストリームを選択 | E-01 | ○ |
| C-11 | lvSubtitlesで字幕ストリームを選択 | E-01 | ○ |
| C-12 | M2TSStreamクラスでストリーム情報を管理 | E-03 | ○ |
| C-13 | IsVideo/IsAudio/IsSubtitle/IsChaptersで種別判定 | E-03 | ○ |
| C-14 | eac3toの終了コードでエラー判定 | E-02 | ○ |
| C-15 | 出力が空の場合は警告表示 | E-03 | ○ |
| C-16 | Task.Runで非同期解析実行 | E-02 | ○ |
| C-17 | ストリーム選択UIはチェックボックス形式 | E-01 | ○ |
| C-18 | オーディオプロファイル設定が可能 | E-01 | ○ |
| C-19 | 「demux Blu-ray chapters」設定が保存される | E-01 | ○ |
| C-20 | Haaliスプリッターが必要な場合がある | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Haaliスプリッターの必要条件（MKV出力時）の詳細な条件分岐が確認できていない
  - 候補：eac3toForm.vbのOnFormClosing / Package.vbのHaali定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - eac3to連携の基本フローは正確
- 0: 低リスク - ストリーム種別判定ロジックは正確
- 1: 中リスク - 外部依存（eac3to/Haali）の検証は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] eac3toForm.vbのStartAnalyze実装を確認
- [ ] Init()でのストリームパース処理を確認
- [ ] GetArgs()のコマンドライン構築を確認
- [ ] 3Dコンテンツ検出条件を確認
- [ ] Haaliスプリッター依存条件を確認
