---
generated_at: 2026-01-21 18:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-WebM Mux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Muxer.vb` - WebMMuxer クラス（988-1007行目）
- E-02: `Source/General/Muxer.vb` - WebMMuxer.SupportedInputTypes（996-999行目）
- E-03: `Source/General/Muxer.vb` - WebMMuxer.OutputExt（1002-1006行目）
- E-04: `Source/General/Muxer.vb` - MkvMuxer クラス（624-986行目）
- E-05: `Source/General/Muxer.vb` - Muxer.Init() WebMMuxer判定（225行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebMMuxerはMkvMuxerを継承 | E-01 | ○ |
| C-02 | OutputExt="webm"を返す | E-03 | ○ |
| C-03 | mkvmergeを使用してMux | E-04 | ○ |
| C-04 | SupportedInputTypesでWebM対応形式に制限 | E-02 | ○ |
| C-05 | 対応形式: mkv, webm, mka, ogg, opus, ivf | E-02 | ○ |
| C-06 | GetArgs()はMkvMuxerから継承 | E-01, E-04 | ○ |
| C-07 | WriteTagfile()はMkvMuxerから継承 | E-01, E-04 | ○ |
| C-08 | WebMMuxerではチャプターをスキップ | E-05 | ○ |
| C-09 | VP8/VP9/AV1ビデオをサポート | E-02 | ○ |
| C-10 | Vorbis/Opusオーディオをサポート | E-02 | ○ |
| C-11 | MkvMuxerの処理を再利用 | E-01 | ○ |
| C-12 | Mux()メソッドはMkvMuxerから継承 | E-01, E-04 | ○ |
| C-13 | Init()でWebMMuxer判定してチャプター除外 | E-05 | ○ |
| C-14 | Package.mkvmergeを使用 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] SupportedInputTypesの対応形式確認
- [ ] MkvMuxerからの継承が正しく機能するか確認
- [ ] WebM制約（チャプター除外等）の動作確認
- [ ] 非対応コーデック使用時のエラー処理確認
