---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-カスタムMux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Muxer.vb` - BatchMuxerクラス定義（538-621行目）
- E-02: `Source/General/Muxer.vb` - Mux()メソッド（559-583行目）
- E-03: `Source/General/Muxer.vb` - Edit()メソッド（585-620行目）
- E-04: `Source/General/Muxer.vb` - OutputTypeValueプロパティ（542行目）
- E-05: `Source/General/Muxer.vb` - CommandLinesプロパティ（543行目）
- E-06: `Source/General/Muxer.vb` - IsSupported()メソッド（555-557行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.32の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BatchMuxerはユーザー定義のコマンドラインで多重化する | E-01, E-02 | ○ |
| C-02 | OutputTypeValueのデフォルト値は"mp4" | E-04 | ○ |
| C-03 | デフォルトのCommandLinesはMP4Boxを使用した例 | E-05 | ○ |
| C-04 | Mux()でマクロ展開後にコマンドを実行する | E-02 (562行目) | ○ |
| C-05 | パイプを含むコマンドはcmd.exe /S /C経由で実行 | E-02 (566-569行目) | ○ |
| C-06 | パイプなしのコマンドは直接実行される | E-02 (570-571行目) | ○ |
| C-07 | 例外発生時はAbortExceptionをスロー | E-02 (574-579行目) | ○ |
| C-08 | IsSupported()は常にTrueを返す | E-06 | ○ |
| C-09 | Edit()でSimpleSettingsFormを使用 | E-03 (586行目) | ○ |
| C-10 | ダイアログのタイトルは"Batch Muxer" | E-03 (586行目) | ○ |
| C-11 | コマンドライン入力でUseCommandlineEditor=True | E-03 (606行目) | ○ |
| C-12 | OK時にTargetFileの拡張子が更新される | E-03 (613-615行目) | ○ |
| C-13 | Log.WriteHeaderでログ出力 | E-02 (560行目) | ○ |
| C-14 | SplitLinesNoEmpty()で空行を除去 | E-02 (562行目) | ○ |
| C-15 | BatchMuxerはMuxerクラスを継承 | E-01 (539行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な機能説明に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトのCommandLinesが正しく記載されているか
- [ ] パイプ処理の条件判定が正確か
- [ ] 例外ハンドリングの動作が正確に記載されているか
- [ ] マクロ展開の説明が十分か
