---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-メタデータ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Muxer.vb` - Tagsプロパティ（36-48行目）
- E-02: `Source/General/Muxer.vb` - TagFileプロパティ（17行目）
- E-03: `Source/General/Muxer.vb` - Init()メソッドのNFO処理（165-176行目）
- E-04: `Source/General/Muxer.vb` - MkvMuxer.WriteTagfile()（691-710行目）
- E-05: `Source/General/Muxer.vb` - MP4Muxer.GetArgs()のitags処理（402-414行目）
- E-06: `Source/Forms/MuxerForm.vb` - dgvTagsの設定（701-706行目）
- E-07: `Source/General/Muxer.vb` - MkvMuxer.Init()カバー処理（655-668行目）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.14の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TagsはBindingList(Of StringPair)型である | E-01 | ○ |
| C-02 | NFOファイルはソースファイルと同じディレクトリから読み込む | E-03 (165行目) | ○ |
| C-03 | 読み込み対象フィールドはtitle, originaltitle等 | E-03 (167行目) | ○ |
| C-04 | XElement.Parse()でNFOを解析 | E-03 (168行目) | ○ |
| C-05 | LINQのWhere句でフィールドを抽出 | E-03 (169行目) | ○ |
| C-06 | Tags.Count = 0の場合WriteTagfile()は早期リターン | E-04 (692-694行目) | ○ |
| C-07 | XML LiteralでMKVタグファイルを構築 | E-04 (696-705行目) | ○ |
| C-08 | タグファイルは_tags.xmlとして保存 | E-04 (707-708行目) | ○ |
| C-09 | MP4ではitagsオプションでタグを設定 | E-05 | ○ |
| C-10 | カバーファイルはitagsのcoverとして追加 | E-05 (404-406行目) | ○ |
| C-11 | dgvTagsのDataSourceにmuxer.Tagsをバインド | E-06 (701行目) | ○ |
| C-12 | タグの追加・削除がDataGridViewで可能 | E-06 (702-703行目) | ○ |
| C-13 | MKV用にカバー画像を自動検出する | E-07 | ○ |
| C-14 | cover.jpg/pngの他small_cover、cover_landも検出 | E-07 (656行目) | ○ |
| C-15 | MuxerFormのtpOptionsでタイトル設定 | E-08 | ○ |
| C-16 | TagFileプロパティはString型 | E-02 | ○ |
| C-17 | NFOパースエラーはTry-Catchで処理 | E-03 (174行目) | ○ |
| C-18 | マクロ展開はMux時に行われる | E-04 (700-701行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な機能説明に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NFOファイルの対応フィールド一覧が正確か
- [ ] MKVとMP4でのタグ処理の違いが正しく記載されているか
- [ ] カバー画像の自動検出パスが正確か
- [ ] DataGridViewの操作説明が十分か
