---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：34-添付ファイル追加

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **C-11 ASS/SSAパース処理詳細**：フォント検出の具体的な実装確認が必要
  2. **C-12 フォント検索パス**：%WINDIR%\Fonts以外の検索パス確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Muxer.vb` - Attachmentsプロパティ（51-64行目）
- E-02: `Source/General/Muxer.vb` - MkvMuxer.Mux()のAttachments処理（764-769行目）
- E-03: `Source/General/Muxer.vb` - MkvMuxer.Init()カバー処理（655-668行目）
- E-04: `Source/Forms/MuxerForm.vb` - 添付ファイルUI（推定）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.14の定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.34の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AttachmentsはList(Of String)型である | E-01 | ○ |
| C-02 | 添付ファイル機能はMKVコンテナでのみ使用可能 | E-02 | ○ |
| C-03 | --attach-fileオプションで添付ファイルを指定 | E-02 (766行目) | ○ |
| C-04 | 添付ファイルの存在確認を行う | E-02 (765行目) | ○ |
| C-05 | MuxerFormで添付ファイル管理UIを提供 | E-04, E-05 | ○ |
| C-06 | カバー画像（cover.jpg/png）を自動検出 | E-03 | ○ |
| C-07 | cover.jpg/png, small_cover, cover_landを検出対象 | E-03 (656行目) | ○ |
| C-08 | CoverFileプロパティに検出したカバーを設定 | E-03 (658行目) | ○ |
| C-09 | Attachmentsプロパティはシリアライズ可能 | E-01 | ○ |
| C-10 | ファイルパスはEscape処理される | E-02 (766行目) | ○ |
| C-11 | ASS/SSA字幕からFontNameを抽出する | **根拠不足** | △ |
| C-12 | %WINDIR%\Fontsを検索対象とする | **根拠不足** | △ |
| C-13 | ログ出力を行う | E-02 (768行目) | ○ |
| C-14 | 添付ファイルループで各ファイルを処理 | E-02 (764行目) | ○ |
| C-15 | MP4は添付ファイル機能をサポートしない | E-02（MkvMuxer限定）| ○ |

## 4) 不足情報（Unknown / Missing）
- C-11: ASS/SSAパース処理の具体的な実装コードが未確認
  - 候補：Subtitle.vbの確認 / MuxerFormの詳細確認
- C-12: フォント検索パスの具体的な実装が未確認
  - 候補：フォント検出関連のコードの追加調査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な添付ファイル処理はコードで確認済み
- 1: 中リスク - フォント自動検出機能の詳細実装が要確認

## 6) レビュアーチェックリスト（最小）
- [ ] Attachmentsプロパティの型と動作が正確か
- [ ] --attach-fileオプションの形式が正確か
- [ ] カバー画像の自動検出パスが正確か
- [ ] フォント検出機能の有無と実装詳細を確認
