---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-AviSynth+連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Video/VideoScript.vb` - VideoScriptクラス定義（12-784行目）
- E-02: `Source/Video/VideoScript.vb` - VideoFilterクラス定義（841-887行目）
- E-03: `Source/Video/VideoScript.vb` - GetScript()メソッド（51-75行目）
- E-04: `Source/Video/VideoScript.vb` - ModifyAVSScript()メソッド（671-710行目）
- E-05: `Source/Video/VideoScript.vb` - GetAvsLoadCode()メソッド（468-572行目）
- E-06: `Source/Video/VideoScript.vb` - Synchronize()メソッド（194-319行目）
- E-07: `Source/Video/VideoScript.vb` - FilterCategory.GetAviSynthDefaults()（922-928行目）
- E-08: `Source/Video/VideoScript.vb` - GetDefaults()（742-764行目）
- E-09: `Source/Video/VideoScript.vb` - ScriptEngine列挙体（1230-1233行目）
- E-10: `Source/Controls/FiltersListView.vb` - フィルタ一覧UI（30-35行目）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.35の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VideoScriptクラスがスクリプト管理を行う | E-01 | ○ |
| C-02 | FiltersプロパティはList(Of VideoFilter)型 | E-01 (22行目) | ○ |
| C-03 | EngineプロパティでAviSynthを指定 | E-01 (24行目), E-09 | ○ |
| C-04 | GetScript()がフィルタのScript連結を行う | E-03 | ○ |
| C-05 | p.CodeAtTopがスクリプト先頭に追加される | E-03 (58-59行目) | ○ |
| C-06 | アクティブなフィルタのみが出力される | E-03 (63行目) | ○ |
| C-07 | ModifyAVSScript()でプラグインロードコード追加 | E-04 | ○ |
| C-08 | GetAvsLoadCode()で関数名に基づくロードコード生成 | E-05 | ○ |
| C-09 | FindFunctionsAVS()で関数名を検出 | E-05 (473行目) | ○ |
| C-10 | IsAvsPluginInAutoLoadFolder()で自動ロードフォルダ確認 | E-05 (488行目) | ○ |
| C-11 | Synchronize()でスクリプト同期と検証 | E-06 | ○ |
| C-12 | AviSynthスクリプトはEncodingOfProcessで保存 | E-06 (294行目) | ○ |
| C-13 | FrameServerFactory.Create()でフレームサーバー起動 | E-06 (305行目) | ○ |
| C-14 | FilterCategory.GetAviSynthDefaults()でデフォルト取得 | E-07 | ○ |
| C-15 | 埋め込みリソースからプロファイル読み込み | E-07 (923行目) | ○ |
| C-16 | デフォルトスクリプトにSource, Crop, QTGMC等含む | E-08 (747-751行目) | ○ |
| C-17 | VideoFilterはCategory、Path、Script、Activeプロパティを持つ | E-02 | ○ |
| C-18 | FiltersListViewでフィルタ一覧を表示 | E-10 | ○ |
| C-19 | LastCodeとの比較で不要な同期をスキップ | E-06 (289行目) | ○ |
| C-20 | AddAutoloadDir処理（ポータブルモード時） | E-04 (694-704行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な機能説明に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ScriptEngine列挙体の定義が正確か
- [ ] GetScript()の処理フローが正確か
- [ ] プラグイン自動ロードの条件が正確か
- [ ] Synchronize()のエラーハンドリングが正確か
