---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-VapourSynth連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Video/VideoScript.vb` - IsVapourSynthプロパティ（39-43行目）
- E-02: `Source/Video/VideoScript.vb` - FileTypeプロパティ（45-49行目）
- E-03: `Source/Video/VideoScript.vb` - ModifyVSScript()メソッド（346-372行目）
- E-04: `Source/Video/VideoScript.vb` - ModifyVSScript(ByRef)メソッド（374-400行目）
- E-05: `Source/Video/VideoScript.vb` - WriteVSCode()メソッド（402-431行目）
- E-06: `Source/Video/VideoScript.vb` - FindFunctionsVS()メソッド（578-610行目）
- E-07: `Source/Video/VideoScript.vb` - GetVsPortableAutoLoadPluginCode()（327-344行目）
- E-08: `Source/Video/VideoScript.vb` - Synchronize()メソッド（194-319行目）
- E-09: `Source/Video/VideoScript.vb` - FilterCategory.GetVapourSynthDefaults()（930-936行目）
- E-10: `Source/Video/VideoScript.vb` - GetDefaults()（754-761行目）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.36の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsVapourSynthでEngine=VapourSynthをチェック | E-01 | ○ |
| C-02 | FileTypeは"vpy"を返す | E-02 | ○ |
| C-03 | ModifyVSScript()でimport文を追加 | E-03 (352-354行目) | ○ |
| C-04 | core = vs.coreを追加 | E-03 (355行目) | ○ |
| C-05 | set_output()が存在しない場合は追加 | E-03 (367-369行目) | ○ |
| C-06 | FindFunctionsVS()でドット記法から関数名抽出 | E-06 | ○ |
| C-07 | WriteVSCode()でcore.std.LoadPlugin生成 | E-05 (419-422行目) | ○ |
| C-08 | s.LoadVapourSynthPluginsでプラグイン自動ロード制御 | E-05 (419行目) | ○ |
| C-09 | UTF-8でスクリプト保存 | E-08 (292行目) | ○ |
| C-10 | FrameServerFactory.Create()でvspipe起動 | E-08 (305行目) | ○ |
| C-11 | VapourSynthFilterProfileDefaults.txtからデフォルト取得 | E-09 (931行目) | ○ |
| C-12 | デフォルトスクリプトにSource, Crop, QTGMC等含む | E-10 | ○ |
| C-13 | ポータブルモード用のプラグインフォルダ追加 | E-07 | ○ |
| C-14 | LastCodeとの比較で不要な同期をスキップ | E-08 (289行目) | ○ |
| C-15 | core.avs.LoadPluginでAviSynthプラグイン使用 | E-05 (420-421行目) | ○ |
| C-16 | Pythonスクリプト（import文）が自動追加 | E-03 | ○ |
| C-17 | sys.pathにScriptsフォルダ追加 | E-03 (357行目) | ○ |
| C-18 | SourceFileLoaderでPythonモジュールロード | E-05 (403-404行目) | ○ |
| C-19 | .pyファイルの場合はSourceFileLoaderを使用 | E-05 (403行目) | ○ |
| C-20 | IsVsPluginInAutoLoadFolder()で自動ロードフォルダ確認 | E-05 (419行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な機能説明に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] import文の追加条件が正確か
- [ ] set_output()追加の条件が正確か
- [ ] プラグインロードコードの形式が正確か
- [ ] UTF-8エンコーディングの指定が正確か
