---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-クロップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/CropForm.vb` - CropFormクラス全体（1-747行目）
- E-02: `Source/Forms/CropForm.vb` - CropActiveSideInternal()（349-378行目）
- E-03: `Source/Forms/CropForm.vb` - MouseCrop()（406-427行目）
- E-04: `Source/Forms/CropForm.vb` - FixMod()（459-465行目）
- E-05: `Source/Forms/CropForm.vb` - UpdateAll()（467-515行目）
- E-06: `Source/Forms/CropForm.vb` - RunAutoCrop()（638-653行目）
- E-07: `Source/Forms/CropForm.vb` - SetCropValues()（598-611行目）
- E-08: `Source/Video/VideoScript.vb` - GetDefaults()でCropフィルタ定義（748, 757行目）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.3の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CropFormでクロップ値の設定を行う | E-01 | ○ |
| C-02 | CropActiveSideInternal()で選択辺のクロップを実行 | E-02 | ○ |
| C-03 | Sideに応じてp.CropXXXを増減 | E-02 (351-375行目) | ○ |
| C-04 | MouseCrop()でマウス位置からクロップ値を計算 | E-03 | ○ |
| C-05 | FixMod()でAutoCorrectCropValues時に偶数補正 | E-04 | ○ |
| C-06 | UpdateAll()で最大値制限を適用 | E-05 (468-485行目) | ○ |
| C-07 | 最大クロップ値はソースサイズの80% | E-05 (468-469行目) | ○ |
| C-08 | Renderer.CropXXXにクロップ値を設定 | E-05 (487-490行目) | ○ |
| C-09 | ステータスバーにSize, Mod, Error, DARを表示 | E-05 (506-514行目) | ○ |
| C-10 | RunAutoCrop()でクロップ値を0にリセット後に自動検出 | E-06 (639-643行目) | ○ |
| C-11 | g.RunAutoCropを進捗コールバック付きで実行 | E-06 (645-649行目) | ○ |
| C-12 | SetCropValues()で4辺のクロップ値を一括設定 | E-07 | ○ |
| C-13 | AviSynth: Crop(left, top, -right, -bottom)形式 | E-08 (748行目) | ○ |
| C-14 | VapourSynth: core.std.Crop形式 | E-08 (757行目) | ○ |
| C-15 | tbPosition.Maximum = p.SourceFrames | E-01 (206行目) | ○ |
| C-16 | CommandManagerでキーボードショートカット管理 | E-01 (159-160行目) | ○ |
| C-17 | GetDefaultMenuCrop()でメニュー項目定義 | E-01 (554-596行目) | ○ |
| C-18 | HDR映像でトーンマッピングオプション使用可能 | E-01 (264-280行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な機能説明に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] FixMod()の偶数補正ロジックが正確か
- [ ] 最大クロップ値（80%）の制限が正確か
- [ ] AviSynth/VapourSynthのCropフィルタ形式が正確か
- [ ] ステータスバーの表示項目が正確か
