---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-リサイズ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Video/VideoScript.vb` - GetDefaults()でResizeフィルタ定義（751, 760行目）
- E-02: `Source/Controls/FiltersListView.vb` - OnItemCheck()（300-317行目）
- E-03: `Source/Forms/CropForm.vb` - IsFilterActive("Resize")（502行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.1の定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.38の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リサイズ機能は映像の解像度を変更する | E-01 | ○ |
| C-02 | AviSynth: BicubicResize(width, height)形式 | E-01 (751行目) | ○ |
| C-03 | VapourSynth: core.resize.Bicubic形式 | E-01 (760行目) | ○ |
| C-04 | %target_width%, %target_height%マクロを使用 | E-01 | ○ |
| C-05 | FiltersListViewでResize有効化時にSetTargetImageSize呼び出し | E-02 (306-311行目) | ○ |
| C-06 | filter.Category = "Resize"でカテゴリ判定 | E-02 (306行目) | ○ |
| C-07 | p.TargetWidth, p.TargetHeightに値を設定 | E-02 (310行目) | ○ |
| C-08 | IsFilterActive("Resize")でリサイズ有効チェック | E-03 | ○ |
| C-09 | Resizeカテゴリのフィルタがデフォルトで無効（False） | E-01 (751, 760行目) | ○ |
| C-10 | 複数のリサイズアルゴリズム対応（Bicubic等） | E-01 | ○ |
| C-11 | MainFormで目標サイズを入力 | E-04 | ○ |
| C-12 | デフォルトスクリプトにResizeフィルタ含む | E-01 | ○ |
| C-13 | AviSynthのデフォルトはBicubicResize | E-01 (751行目) | ○ |
| C-14 | VapourSynthのデフォルトはresize.Bicubic | E-01 (760行目) | ○ |
| C-15 | filter.Activeプロパティで有効/無効を管理 | E-02 (314行目) | ○ |
| C-16 | CheckState.Checkedでフィルタを有効化 | E-02 (314行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な機能説明に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AviSynth/VapourSynthのResizeフィルタ形式が正確か
- [ ] マクロ名（%target_width%等）が正確か
- [ ] SetTargetImageSize()の呼び出し条件が正確か
- [ ] デフォルトのリサイズアルゴリズムが正確か
