---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-デインターレース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Video/VideoScript.vb` - GetDefaults()でFieldフィルタ定義（749, 758行目）
- E-02: `Source/Video/VideoScript.vb` - FilterParameters.Definitions（1001-1186行目）
- E-03: `Source/Video/VideoScript.vb` - QTGMC TFF設定（1122-1124行目）
- E-04: `Source/Video/VideoScript.vb` - QTGMC Preset設定（1125-1136行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.39の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デインターレースはFieldカテゴリのフィルタ | E-01 | ○ |
| C-02 | AviSynth: QTGMC(preset="Medium")形式 | E-01 (749行目) | ○ |
| C-03 | VapourSynth: SetFieldBased + havsfunc.QTGMC形式 | E-01 (758行目) | ○ |
| C-04 | TFF = True/Falseでフィールドオーダー指定 | E-03 | ○ |
| C-05 | havsfunc.QTGMCのTFF選択肢定義 | E-03 | ○ |
| C-06 | QTGMC Presetは Draft から Placebo まで | E-04 | ○ |
| C-07 | FilterParameters.Definitionsでパラメータ定義 | E-02 | ○ |
| C-08 | デフォルトフィルタは無効（False）で定義 | E-01 (749, 758行目) | ○ |
| C-09 | VapourSynthではhavsfuncパッケージ使用 | E-01 (758行目) | ○ |
| C-10 | SetFieldBasedでフィールド属性設定 | E-01 (758行目) | ○ |
| C-11 | 1=BFF, 2=TFFのコメント付き | E-01 (758行目) | ○ |
| C-12 | PresetはString型で指定（ダブルクォート） | E-04 | ○ |
| C-13 | AviSynthのQTGMCはPresetパラメータ使用 | E-04 | ○ |
| C-14 | Medium Presetがデフォルト | E-01 (749, 758行目) | ○ |
| C-15 | Fieldカテゴリとして分類 | E-01 | ○ |
| C-16 | 複数のPreset選択肢を提供 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な機能説明に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AviSynth/VapourSynthのQTGMC形式が正確か
- [ ] TFF/BFF設定の選択肢が正確か
- [ ] Preset選択肢の一覧が正確か
- [ ] SetFieldBasedの引数（1=BFF, 2=TFF）が正確か
