---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-mkvextract Demux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - Demuxer基底クラス（7-108行目）
- E-02: `Source/General/Demux.vb` - mkvDemuxerクラス（711-1024行目）
- E-03: `Source/General/Demux.vb` - mkvDemuxer.Run（721-842行目）
- E-04: `Source/General/Demux.vb` - mkvDemuxer.Demux（852-995行目）
- E-05: `Source/General/Demux.vb` - GetAttachments（1003-1017行目）
- E-06: `Source/Forms/StreamDemuxForm.vb` - StreamDemuxFormクラス
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.4定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mkvDemuxerはDemuxerを継承 | E-01, E-02 | ○ |
| C-02 | InputExtensionsは{"mkv", "webm"} | E-02 | ○ |
| C-03 | mkvmerge --identifyでストリーム情報取得 | E-03 | ○ |
| C-04 | 724行目でmkvmerge実行 | E-03 | ○ |
| C-05 | StreamDemuxFormで選択UI表示 | E-03, E-06 | ○ |
| C-06 | mkvextract tracksで抽出 | E-04 | ○ |
| C-07 | mkvextract chaptersでチャプター抽出 | E-03 | ○ |
| C-08 | XML/OGG両形式でチャプター出力 | E-03 | ○ |
| C-09 | mkvextract timestamps_v2でタイムスタンプ抽出 | E-03 | ○ |
| C-10 | VFR判定でタイムスタンプ抽出制御 | E-03 | ○ |
| C-11 | mkvextract attachmentsで添付抽出 | E-03 | ○ |
| C-12 | mkvextract tagsでタグ抽出 | E-03 | ○ |
| C-13 | BPSタグノードを除外 | E-03 | ○ |
| C-14 | m4aはaacとして抽出 | E-04 | ○ |
| C-15 | mks字幕はmkvmergeで抽出 | E-04 | ○ |
| C-16 | 終了コード0,1,2を許容 | E-03, E-04 | ○ |
| C-17 | フォールバックでffmpegDemuxer使用 | E-04 | ○ |
| C-18 | GetAttachmentsで添付情報取得 | E-05 | ○ |
| C-19 | cover系はプレフィックスなし | E-02 | ○ |
| C-20 | OutputExtensionsに複数形式含む | E-02 | ○ |
| C-21 | HasConfigDialogはTrue | E-02 | ○ |
| C-22 | Nameは"mkvextract: Demux" | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる情報が中心
- 0: 低リスク - 外部ツール連携の動作はコードで明確に定義

## 6) レビュアーチェックリスト（最小）
- [ ] mkvDemuxer.Run()の処理フローを確認
- [ ] Demux()メソッドのコマンドライン構築を確認
- [ ] フォールバック処理の動作条件を確認
- [ ] 添付ファイルパス生成ロジックを確認
