---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-ノイズ除去

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Video/VideoScript.vb` - GetDefaults()でNoiseフィルタ定義（750, 759行目）
- E-02: `Source/Video/VideoScript.vb` - FilterCategory.ParseFilterProfilesIniContent()（938-982行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.40の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ノイズ除去はNoiseカテゴリのフィルタ | E-01 | ○ |
| C-02 | AviSynth: DFTTest(sigma=6, tbsize=1)形式 | E-01 (750行目) | ○ |
| C-03 | VapourSynth: core.dfttest.DFTTest形式 | E-01 (759行目) | ○ |
| C-04 | sigma=6がデフォルトのノイズ除去強度 | E-01 | ○ |
| C-05 | AviSynthのtbsize=1（空間フィルタのみ） | E-01 (750行目) | ○ |
| C-06 | VapourSynthのtbsize=3（時間軸処理有効） | E-01 (759行目) | ○ |
| C-07 | VapourSynthでopt=3オプション使用 | E-01 (759行目) | ○ |
| C-08 | デフォルトフィルタは無効（False）で定義 | E-01 (750, 759行目) | ○ |
| C-09 | Noiseカテゴリとして分類 | E-01 | ○ |
| C-10 | 埋め込みリソースからフィルタプロファイル読み込み | E-02 | ○ |
| C-11 | カテゴリは[Noise]形式で定義 | E-02 (946-948行目) | ○ |
| C-12 | フィルタ名=スクリプト形式でパース | E-02 (972-976行目) | ○ |
| C-13 | VapourSynthではcore.dfttest名前空間使用 | E-01 (759行目) | ○ |
| C-14 | AviSynthではDFTTest関数名を直接使用 | E-01 (750行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な機能説明に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AviSynth/VapourSynthのDFTTest形式が正確か
- [ ] sigmaとtbsizeのデフォルト値が正確か
- [ ] VapourSynthのoptオプションが正確か
- [ ] カテゴリ名がNoiseで正確か
