---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：41-シャープ化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足（設計判断による記載）
  2. **BR-41-01フィルタ順序ルール**：根拠不足（ベストプラクティスからの推測）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Video/AviSynthFilterProfileDefaults.txt` 133-142行目 - Sharpenフィルタ定義
- E-02: `Source/Video/VapourSynthFilterProfileDefaults.txt` 131-140行目 - VSシャープフィルタ定義
- E-03: `Source/Forms/PreviewForm.vb` 303-311行目 - Open()メソッド
- E-04: `Source/Video/VideoRenderer.vb` 101-148行目 - Draw()メソッド
- E-05: `Source/Video/VideoRenderer.vb` 56-71行目 - コンストラクタ
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 42行目 - 機能No.41定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - MainForm/PreviewForm関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シャープ化機能はAviSynth+/VapourSynthフィルタを使用 | E-01, E-02 | ○ |
| C-02 | CAS, FineSharp, LSFmod等のフィルタが利用可能 | E-01, E-02 | ○ |
| C-03 | $select$/$enter_text$マクロでパラメータ入力 | E-01 | ○ |
| C-04 | PreviewFormでプレビュー確認可能 | E-03 | ○ |
| C-05 | VideoRendererがDirect2Dで描画 | E-04, E-05 | ○ |
| C-06 | フィルタはLineカテゴリ配下に配置 | E-01, E-02 | ○ |
| C-07 | CASの強度パラメータは0.0-1.0 | E-01, E-02 | ○ |
| C-08 | FineSharpにはLight/Moderate/Strongプリセット | E-01, E-02 | ○ |
| C-09 | MainFormのFiltersListViewでフィルタ選択 | E-07 | ○ |
| C-10 | FrameServerインターフェースでフレーム取得 | E-03 | ○ |
| C-11 | スクリプトは.avs/.vpyファイルとして出力 | E-03 | ○ |
| C-12 | VapourSynthではhavsfuncが必要 | E-02 | ○ |
| C-13 | aWarpSharp2も利用可能 | E-01, E-02 | ○ |
| C-14 | MSharpenフィルタが両エンジンで利用可能 | E-01, E-02 | ○ |
| C-15 | pSharpenフィルタが利用可能 | E-01, E-02 | ○ |
| C-16 | 機能一覧での機能名は「シャープ化」 | E-06 | ○ |
| C-17 | プレビュー応答は100ms以内が目標 | **根拠なし** | △ |
| C-18 | シャープフィルタはリサイズ後に適用推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体値（100ms等）は設計判断による記載であり、ソースコードからの直接根拠なし
  - 候補：ベンチマークテスト / パフォーマンス要件定義書 / ユーザーマニュアル
- フィルタ適用順序のベストプラクティスはドキュメント化されていない
  - 候補：ヘルプドキュメント / チュートリアル / 開発者ガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フィルタ定義の根拠は明確
- 0: 低リスク - コード構造の説明は正確
- 1: 中リスク - パフォーマンス要件は検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] AviSynthFilterProfileDefaults.txtの[Line]セクションでSharpenフィルタ定義を確認
- [ ] VapourSynthFilterProfileDefaults.txtの[Line]セクションでSharpenフィルタ定義を確認
- [ ] PreviewForm.vbのOpen()メソッドでFrameServer初期化を確認
- [ ] VideoRenderer.vbのDraw()メソッドでDirect2D描画を確認
- [ ] パフォーマンス要件が適切か検討
