---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：42-色調補正

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（50ms以内）**：根拠不足（設計判断による記載）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Video/AviSynthFilterProfileDefaults.txt` 28-44行目 - [Color]セクション
- E-02: `Source/Video/VapourSynthFilterProfileDefaults.txt` 22-51行目 - [Color]セクション
- E-03: `Source/Forms/CropForm.vb` 274-280行目 - 高コントラストモード処理
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 43行目 - 機能No.42定義
- E-05: `Source/Video/VideoRenderer.vb` - 描画処理
- E-06: `Source/Forms/PreviewForm.vb` - プレビュー処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Tweakフィルタで色相・彩度・明るさ・コントラスト調整可能 | E-01 (34行目), E-02 (36行目) | ○ |
| C-02 | TweakにはNeutral/Brighter/Vivid等のプリセットがある | E-01, E-02 | ○ |
| C-03 | ColorYUVで自動ゲイン・ホワイトバランス調整可能 | E-01 (30行目) | ○ |
| C-04 | Grayscale()でグレースケール変換可能 | E-01 (31行目), E-02 (35行目) | ○ |
| C-05 | Levelsで"TV->PC"/"PC->TV"変換可能 | E-01 (32行目) | ○ |
| C-06 | AutoAdjustフィルタで自動色調補正可能 | E-01 (29行目) | ○ |
| C-07 | CropFormで高コントラストモードが利用可能 | E-03 | ○ |
| C-08 | AviSynthではLevels(0, 2.2, 255, 0, 255)を使用 | E-03 (276行目) | ○ |
| C-09 | VapourSynthではadjust.Tweakを使用 | E-03 (278行目) | ○ |
| C-10 | p.CropWithHighContrastフラグで制御 | E-03 (274行目) | ○ |
| C-11 | ConvertBitsでビット深度変換可能 | E-01 (35-36行目) | ○ |
| C-12 | z_ConvertFormatで色空間変換可能 | E-01 (38行目) | ○ |
| C-13 | fmtc.matrixで色行列変換可能 | E-02 (23行目) | ○ |
| C-14 | Ditherフィルタでガンマ・リニア変換可能 | E-01 (42-43行目), E-02 (41行目) | ○ |
| C-15 | 機能一覧での機能名は「色調補正」 | E-04 | ○ |
| C-16 | プレビュー応答は50ms以内が目標 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体値（50ms等）は設計判断による記載であり、ソースコードからの直接根拠なし
  - 候補：ベンチマークテスト / パフォーマンス要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フィルタ定義の根拠は明確
- 0: 低リスク - CropFormの高コントラストモード処理は正確
- 1: 中リスク - パフォーマンス要件は検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] AviSynthFilterProfileDefaults.txtの[Color]セクション（28-44行目）を確認
- [ ] VapourSynthFilterProfileDefaults.txtの[Color]セクション（22-51行目）を確認
- [ ] CropForm.vbの高コントラストモード処理（274-280行目）を確認
- [ ] Tweakフィルタのプリセット内容が正確か確認
