---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：43-HDR処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（GPU使用時50-100ms）**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/CropForm.vb` 264-272行目 - CropWithTonemapping処理
- E-02: `Source/General/Project.vb` 55行目 - CropWithTonemapping定義
- E-03: `Source/General/Project.vb` 80行目 - ExtractHdrmetadata
- E-04: `Source/General/Project.vb` 93-94行目 - Hdr10PlusMetadataFile, HdrDolbyVisionMetadataFile
- E-05: `Source/General/Project.vb` 134行目 - SourceVideoHdrFormat
- E-06: `Source/Video/AviSynthFilterProfileDefaults.txt` 45-63行目 - HDR to SDRフィルタ
- E-07: `Source/Video/VapourSynthFilterProfileDefaults.txt` 47-51行目 - Tonemapフィルタ
- E-08: `Source/General/Thumbnailer.vb` 299-306行目 - サムネイル生成時HDR処理
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 44行目 - 機能No.43定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CropWithTonemappingフラグでトーンマッピング制御 | E-01 (264行目), E-02 | ○ |
| C-02 | ビット深度が8より大きくHDRの場合にトーンマッピング | E-01 (265行目) | ○ |
| C-03 | AviSynth+AVSLibPlaceboでトーンマッピング | E-01 (266-268行目) | ○ |
| C-04 | VapourSynth+VSLibPlaceboでトーンマッピング | E-01 (268-269行目) | ○ |
| C-05 | ConvertBits(16)で16bitに変換後処理 | E-01 (267行目) | ○ |
| C-06 | placebo.Tonemap(src_csp=1, dst_csp=0)でHDR10→SDR | E-01, E-07 | ○ |
| C-07 | dynamic_peak_detection=0で動的検出を無効化 | E-01 (269行目), E-08 (304行目) | ○ |
| C-08 | tone_mapping_function=7を使用 | E-01 (269行目), E-08 (304行目) | ○ |
| C-09 | SourceVideoHdrFormatでHDRフォーマット保持 | E-05 | ○ |
| C-10 | Hdr10PlusMetadataFileでHDR10+メタデータパス保持 | E-04 | ○ |
| C-11 | HdrDolbyVisionMetadataFileでDolby Visionメタデータ保持 | E-04 | ○ |
| C-12 | ExtractHdrmetadataでメタデータ抽出モード設定 | E-03 | ○ |
| C-13 | Package.VSLibPlacebo.RequirementsFulfilledでプラグイン確認 | E-01 (268行目), E-08 (303行目) | ○ |
| C-14 | Package.AVSLibPlacebo.RequirementsFulfilledでプラグイン確認 | E-01 (266行目) | ○ |
| C-15 | libplacebo_Tonemap()関数名（AviSynth） | E-01 (267行目) | ○ |
| C-16 | core.placebo.Tonemap関数名（VapourSynth） | E-01 (269行目), E-08 (304行目) | ○ |
| C-17 | サムネイル生成時もHDR対応 | E-08 (299-306行目) | ○ |
| C-18 | fileHdrFormatでソースHDR判定 | E-08 (300-302行目) | ○ |
| C-19 | 機能一覧での機能名は「HDR処理」 | E-09 | ○ |
| C-20 | GPU使用時のパフォーマンスは50-100ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件はベンチマーク結果に基づく推定であり、ソースコードからの直接根拠なし
  - 候補：ベンチマークテスト結果 / libplaceboドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CropFormのトーンマッピング処理は正確
- 0: 低リスク - プラグイン確認ロジックは正確
- 0: 低リスク - サムネイル生成時のHDR処理は正確
- 1: 中リスク - パフォーマンス要件は検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CropForm.vbのCropWithTonemapping処理（264-272行目）を確認
- [ ] Project.vbのHDR関連プロパティ（55,80,93-94,134行目）を確認
- [ ] Thumbnailer.vbのHDR処理（299-306行目）を確認
- [ ] VapourSynthFilterProfileDefaults.txtのTonemapフィルタ定義を確認
- [ ] libplaceboのパラメータ（src_csp, dst_csp, tone_mapping_function）が正確か確認
