---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：44-フレームカット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **PreviewFormでのカット範囲指定UI詳細**：根拠不足（UIの詳細未確認）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb` 61-63行目 - CutFrameCount, CutFrameRate, CuttingMode
- E-02: `Source/General/Project.vb` 104-105行目 - Ranges, RangesBasedOnFPS
- E-03: `Source/General/Project.vb` 152行目 - TrimCode
- E-04: `Source/General/Audio.vb` 36行目 - cutting = p.Ranges.Count > 0
- E-05: `Source/General/Audio.vb` 247-265行目 - Cut()メソッド、CuttingModeによる分岐
- E-06: `Source/General/Misc.vb` 1714-1760行目 - 字幕カット処理
- E-07: `Source/Encoding/QSVEnc.vb` 1361-1362行目 - --trim引数生成
- E-08: `Source/Encoding/VCEEnc.vb` 205-206行目 - Dolby Vision RPUトリム
- E-09: `Source/Controls/FiltersListView.vb` 190行目 - g.UpdateTrim呼び出し
- E-10: `Source/General/Macro.vb` 522-531行目 - %sel_start%, %sel_end%マクロ
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 45行目 - 機能No.44定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rangesプロパティがカット範囲リストを保持 | E-02 | ○ |
| C-02 | TrimCodeプロパティがTrimスクリプトを保持 | E-03 | ○ |
| C-03 | CutFrameCount/CutFrameRateでカット後フレーム情報を保持 | E-01 | ○ |
| C-04 | CuttingModeでカット方式を選択（mkvmerge/NicAudio/DirectShow） | E-01, E-05 | ○ |
| C-05 | p.Ranges.Count > 0でカット有無判定 | E-04, E-06 | ○ |
| C-06 | Audio.Cut()でCuttingModeによる分岐処理 | E-05 | ○ |
| C-07 | CuttingMode.mkvmergeでCutMkvmerge呼び出し | E-05 (257行目) | ○ |
| C-08 | CuttingMode.NicAudioでCutNicAudio呼び出し | E-05 (259-261行目) | ○ |
| C-09 | CuttingMode.DirectShowで直接処理 | E-05 (265行目) | ○ |
| C-10 | 字幕カットでmkvmerge --split parts-frames使用 | E-06 (1760行目) | ○ |
| C-11 | ffmpegで一時aviファイル作成後mkvmerge処理 | E-06 (1732-1742行目) | ○ |
| C-12 | QSVEncで--trim {Start}:{End}形式使用 | E-07 | ○ |
| C-13 | VCEEncでDolby Vision RPUトリム対応 | E-08 | ○ |
| C-14 | g.UpdateTrim()でTrimコード更新 | E-09 | ○ |
| C-15 | %sel_start%, %sel_end%マクロで範囲参照可能 | E-10 | ○ |
| C-16 | RangesBasedOnFPSでFPS変更追跡 | E-02 | ○ |
| C-17 | 機能一覧での機能名は「フレームカット」 | E-11 | ○ |
| C-18 | PreviewFormでカット範囲を視覚的に指定 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- PreviewFormでのカット範囲指定UIの詳細（ボタン、キーボードショートカット等）は未確認
  - 候補：PreviewForm.vbの詳細確認 / ユーザーマニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Project.vbのカット関連プロパティは正確
- 0: 低リスク - Audio.Cut()の分岐処理は正確
- 0: 低リスク - 字幕カット処理は正確
- 1: 中リスク - PreviewFormのUI詳細は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Project.vbのRanges, TrimCode, CuttingMode定義を確認
- [ ] Audio.vbのCut()メソッドでCuttingModeによる分岐を確認
- [ ] Misc.vbの字幕カット処理（1714-1760行目）を確認
- [ ] QSVEnc.vbの--trim引数生成（1361-1362行目）を確認
- [ ] PreviewFormでのカット範囲指定UIを確認
